/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource;

import com.alipay.sofa.tracer.plugins.datasource.ExtendedConnection;
import com.alipay.sofa.tracer.plugins.datasource.Prop;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BasePreparedStatement
implements PreparedStatement {
    private final ExtendedConnection connection;
    private final Prop prop;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean closed;
    private PreparedStatement realPreparedStatement;
    private final List<PreparedParameter> preparedParameters = new ArrayList<PreparedParameter>();

    public BasePreparedStatement(ExtendedConnection connection) {
        this.connection = connection;
        this.prop = connection.getProp();
    }

    public void initPreparedStatement(String sql) throws Exception {
        if (this.closed) {
            throw new IllegalStateException("BasePreparedStatement has been closed");
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.realPreparedStatement = this.doPrepareStatement(sql);
            for (PreparedParameter preparedParameter : this.preparedParameters) {
                preparedParameter.invoke(this.realPreparedStatement);
            }
        }
    }

    public List<PreparedParameter> getPreparedParameters() {
        return this.preparedParameters;
    }

    protected abstract PreparedStatement doPrepareStatement(String var1) throws SQLException;

    private void checkState() throws SQLException {
        if (!this.initialized.get()) {
            throw new IllegalStateException("BasePreparedStatement has not been initialized");
        }
        if (this.closed) {
            throw new IllegalStateException("BasePreparedStatement has been closed");
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeUpdate();
    }

    private void setParameter(String methodName, Object ... args) {
        Method method = this.prop.getTargetMethod(methodName);
        if (method == null) {
            throw new IllegalStateException("method: " + methodName + " not registered");
        }
        this.preparedParameters.add(new PreparedParameter(this.prop.getTargetMethod(methodName), args));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter("ps_setNull_ii", parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter("ps_setBoolean", parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter("ps_setByte", parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter("ps_setShort", parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter("ps_setInt", parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter("ps_setLong", parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter("ps_setFloat", parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter("ps_setDouble", parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter("ps_setBigDecimal", parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter("ps_setString", parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter("ps_setBytes", parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter("ps_setDate_id", parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter("ps_setTime_it", parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter("ps_setTimestamp_it", parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter("ps_setAsciiStream_iii", parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter("ps_setUnicodeStream", parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter("ps_setBinaryStream_iii", parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkState();
        this.realPreparedStatement.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter("ps_setObject_ioi", parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter("ps_setObject_io", parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.setParameter("ps_addBatch", new Object[0]);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParameter("ps_setCharacterStream_iri", parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParameter("ps_setRef", parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParameter("ps_setBlob_ib", parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParameter("ps_setClob_ic", parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParameter("ps_setArray", parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter("ps_setDate_idc", parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter("ps_setTime_itc", parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter("ps_setTime_itc", parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter("ps_setNull_iis", parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter("ps_setURL", parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParameter("ps_setRowId", parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParameter("ps_setNString", parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setParameter("ps_setNCharacterStream_irl", parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setParameter("ps_setNClob_IN", parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter("ps_setClob_irl", parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setParameter("ps_setBlob_irl", parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter("ps_nclob_irl", parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setParameter("ps_setSQLXML", parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter("ps_setObject_ioii", parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter("ps_setAsciiStream_iil", parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter("ps_setBinaryStream_iil", parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter("ps_setCharacterStream_irl", parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter("ps_setAsciiStream_ii", parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter("ps_setBinaryStream_ii", parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter("ps_setCharacterStream_ir", parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setParameter("ps_setNCharacterStream_ir", parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter("ps_setClob_ir", parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setParameter("ps_setBlob_ii", parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter("ps_setNClob_ir", parameterIndex, reader);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.realPreparedStatement != null) {
            this.realPreparedStatement.close();
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.setParameter("setMaxFieldSize", max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setParameter("setMaxRows", max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.setParameter("setEscapeProcessing", enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.setParameter("setQueryTimeout", seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkState();
        this.realPreparedStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        this.realPreparedStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.setParameter("setCursorName", name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.setParameter("setFetchDirection", direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.setParameter("setFetchSize", rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkState();
        this.realPreparedStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkState();
        this.realPreparedStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.setParameter("setPoolable", poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkState();
        this.realPreparedStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkState();
        return this.realPreparedStatement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkState();
        return this.realPreparedStatement.isWrapperFor(iface);
    }

    public class PreparedParameter {
        private final Method method;
        private final Object[] params;

        private PreparedParameter(Method method, Object ... params) {
            this.method = method;
            this.params = params;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getParams() {
            return this.params;
        }

        Object invoke(Object target) throws SQLException {
            try {
                return this.method.invoke(target, this.params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

