/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource;

import com.alipay.sofa.tracer.plugins.datasource.ExtendedConnection;
import com.alipay.sofa.tracer.plugins.datasource.ExtendedStatement;
import com.alipay.sofa.tracer.plugins.datasource.Interceptor;
import com.alipay.sofa.tracer.plugins.datasource.Invocation;
import com.alipay.sofa.tracer.plugins.datasource.Prop;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class BaseDataSource
implements DataSource {
    protected DataSource delegate;
    protected List<Interceptor> interceptors;
    protected List<Interceptor> dataSourceInterceptors;
    protected final Prop prop;
    protected AtomicBoolean initialized = new AtomicBoolean();

    public BaseDataSource(DataSource delegate) {
        this.delegate = delegate;
        this.prop = new Prop();
    }

    public DataSource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(DataSource delegate) {
        this.delegate = delegate;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public List<Interceptor> getDataSourceInterceptors() {
        return this.dataSourceInterceptors;
    }

    public void setDataSourceInterceptors(List<Interceptor> dataSourceInterceptors) {
        this.dataSourceInterceptors = dataSourceInterceptors;
    }

    public Prop getProp() {
        return this.prop;
    }

    public abstract void init();

    private void checkInit() {
        if (!this.initialized.get()) {
            throw new IllegalStateException("DataSource has not been initialized");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkInit();
        try {
            DataSourceInterceptorChain dataSourceInterceptorChain = new DataSourceInterceptorChain(new Invocation(this.prop.getTargetMethod("getConnection"), this.delegate, new Object[0]));
            Connection conn = (Connection)dataSourceInterceptorChain.proceed();
            if (conn != null) {
                return new ExtendedConnection(this, conn, this.prop);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        throw new SQLException("getConnection failed");
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("please setup user and password in delegate dataSource");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    class DataSourceInterceptorChain
    implements Interceptor.Chain {
        private int index = 0;
        private Invocation invocation;

        DataSourceInterceptorChain(Invocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object proceed() throws Exception {
            if (this.hasNext()) {
                return this.next().intercept(this);
            }
            return this.invocation.invoke();
        }

        @Override
        public String getOriginalSql() {
            throw new UnsupportedOperationException("this operation not unsupported");
        }

        @Override
        public String getProcessingSql() {
            throw new UnsupportedOperationException("this operation unsupported");
        }

        @Override
        public void setProcessingSql(String processingSql) {
            throw new UnsupportedOperationException("this operation unsupported");
        }

        @Override
        public BaseDataSource getDataSource() {
            return BaseDataSource.this;
        }

        @Override
        public ExtendedConnection getConnection() {
            throw new UnsupportedOperationException("this operation unsupported");
        }

        @Override
        public ExtendedStatement getStatement() {
            throw new UnsupportedOperationException("this operation unsupported");
        }

        @Override
        public boolean hasNext() {
            return BaseDataSource.this.dataSourceInterceptors != null && this.index < BaseDataSource.this.dataSourceInterceptors.size();
        }

        @Override
        public Interceptor next() {
            return BaseDataSource.this.dataSourceInterceptors.get(this.index++);
        }
    }
}

