/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.triple;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.invoke.Invoker;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UniqueIdInvoker
implements Invoker {
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLook = this.rwLock.writeLock();
    private Map<String, Invoker> uniqueIdInvokerMap = new HashMap<String, Invoker>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerInvoker(ProviderConfig providerConfig, Invoker invoker) {
        this.writeLook.lock();
        try {
            String uniqueId = this.getUniqueId(providerConfig);
            boolean bl = this.uniqueIdInvokerMap.putIfAbsent(uniqueId, invoker) == null;
            return bl;
        }
        finally {
            this.writeLook.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unRegisterInvoker(ProviderConfig providerConfig) {
        this.writeLook.lock();
        try {
            String uniqueId = this.getUniqueId(providerConfig);
            boolean bl = this.uniqueIdInvokerMap.remove(uniqueId) != null;
            return bl;
        }
        finally {
            this.writeLook.unlock();
        }
    }

    public boolean hasInvoker() {
        this.readLock.lock();
        try {
            boolean bl = !this.uniqueIdInvokerMap.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String getUniqueId(ProviderConfig providerConfig) {
        String uniqueId = providerConfig.getUniqueId();
        return null == uniqueId ? "" : uniqueId;
    }

    private String getUniqueIdFromInvokeContext() {
        String uniqueId = (String)RpcInvokeContext.getContext().get("_SOFA_UNIQUE_ID");
        return uniqueId == null ? "" : uniqueId;
    }

    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        String interfaceName = request.getInterfaceName();
        String uniqueId = this.getUniqueIdFromInvokeContext();
        Invoker invoker = this.findInvoker(interfaceName, uniqueId);
        return invoker.invoke(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker findInvoker(String interfaceName, String uniqueId) {
        this.readLock.lock();
        try {
            if (this.uniqueIdInvokerMap.isEmpty()) {
                throw new SofaRpcException(110, "Cannot find service of [" + interfaceName + "] with uniqueId [" + uniqueId + "]");
            }
            Invoker invoker = this.uniqueIdInvokerMap.get(uniqueId);
            if (null == invoker) {
                if (StringUtils.isNotEmpty(uniqueId)) {
                    throw new SofaRpcException(110, "Cannot find service of [" + interfaceName + "] with uniqueId [" + uniqueId + "]");
                }
                if (this.uniqueIdInvokerMap.size() > 1) {
                    throw new SofaRpcException(110, "Cannot find service of [" + interfaceName + "] with uniqueId [" + uniqueId + "]");
                }
                invoker = this.uniqueIdInvokerMap.values().stream().findFirst().get();
            }
            Invoker invoker2 = invoker;
            return invoker2;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

