/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import java.util.Map;

@AutoActive(consumerSide=true)
@Extension(value="consumerCustomHeader", order=0x7FFFFFFF)
public class ConsumerCustomHeaderFilter
extends Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        RpcInvokeContext context = RpcInvokeContext.getContext();
        try {
            Map<String, Object> customHeader = context.getCustomHeader();
            if (CommonUtils.isNotEmpty(customHeader)) {
                request.addRequestProps(customHeader);
            }
            SofaResponse sofaResponse = invoker.invoke(request);
            return sofaResponse;
        }
        finally {
            context.clearCustomHeader();
        }
    }
}

