/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.StopWatch;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.message.ResponseFuture;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RpcInternalContext
implements Cloneable {
    private static final boolean ATTACHMENT_ENABLE = RpcConfigs.getBooleanValue("context.attachment.enable");
    private static final ThreadLocal<RpcInternalContext> LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<Deque<RpcInternalContext>> DEQUE_LOCAL = new TransmittableThreadLocal();
    private ResponseFuture<?> future;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private StopWatch stopWatch = new StopWatch();
    private Boolean providerSide;
    private ProviderInfo providerInfo;

    public static void setContext(RpcInternalContext context) {
        LOCAL.set(context);
    }

    public static RpcInternalContext getContext() {
        RpcInternalContext context = LOCAL.get();
        if (context == null) {
            context = new RpcInternalContext();
            LOCAL.set(context);
        }
        return context;
    }

    public static RpcInternalContext peekContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    public static void pushContext() {
        RpcInternalContext context = LOCAL.get();
        if (context != null) {
            Deque<RpcInternalContext> deque = DEQUE_LOCAL.get();
            if (deque == null) {
                deque = new ArrayDeque<RpcInternalContext>();
                DEQUE_LOCAL.set(deque);
            }
            deque.push(context);
            LOCAL.set(null);
        }
    }

    public static void popContext() {
        RpcInternalContext context;
        Deque<RpcInternalContext> deque = DEQUE_LOCAL.get();
        if (deque != null && (context = deque.peek()) != null) {
            LOCAL.set(deque.pop());
        }
    }

    public static void removeAllContext() {
        LOCAL.remove();
        DEQUE_LOCAL.remove();
    }

    public static boolean isAttachmentEnable() {
        return ATTACHMENT_ENABLE;
    }

    protected RpcInternalContext() {
    }

    public boolean isProviderSide() {
        return this.providerSide != null && this.providerSide != false;
    }

    public RpcInternalContext setProviderSide(Boolean isProviderSide) {
        this.providerSide = isProviderSide;
        return this;
    }

    public boolean isConsumerSide() {
        return this.providerSide != null && this.providerSide == false;
    }

    public <T> ResponseFuture<T> getFuture() {
        return this.future;
    }

    public RpcInternalContext setFuture(ResponseFuture<?> future) {
        this.future = future;
        return this;
    }

    public RpcInternalContext setLocalAddress(InetSocketAddress address) {
        this.localAddress = address;
        return this;
    }

    @Deprecated
    public RpcInternalContext setLocalAddress(String host, int port) {
        if (host == null) {
            return this;
        }
        if (port < 0 || port > 65535) {
            port = 0;
        }
        this.localAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public RpcInternalContext setRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
        return this;
    }

    public RpcInternalContext setRemoteAddress(String host, int port) {
        if (host == null) {
            return this;
        }
        if (port < 0 || port > 65535) {
            port = 0;
        }
        this.remoteAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRemoteHostName() {
        return NetUtils.toIpString(this.remoteAddress);
    }

    public Object getAttachment(String key) {
        return key == null ? null : this.attachments.get(key);
    }

    public RpcInternalContext setAttachment(String key, Object value) {
        if (key == null) {
            return this;
        }
        if (!ATTACHMENT_ENABLE) {
            if (!RpcInternalContext.isHiddenParamKey(key)) {
                return this;
            }
        } else if (!RpcInternalContext.isValidInternalParamKey(key)) {
            throw new IllegalArgumentException(LogCodes.getLog("020080001", Character.valueOf('_'), Character.valueOf('.')));
        }
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    public Object removeAttachment(String key) {
        return this.attachments.remove(key);
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public RpcInternalContext setAttachments(Map<String, Object> attachments) {
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry<String, Object> entry : attachments.entrySet()) {
                this.setAttachment(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public RpcInternalContext clearAttachments() {
        if (this.attachments != null && this.attachments.size() > 0) {
            this.attachments.clear();
        }
        return this;
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    public void clear() {
        this.setRemoteAddress(null).setLocalAddress(null).setFuture(null).setProviderSide(null).setProviderInfo(null);
        this.attachments = new ConcurrentHashMap<String, Object>();
        this.stopWatch.reset();
    }

    public RpcInternalContext setProviderInfo(ProviderInfo providerInfo) {
        this.providerInfo = providerInfo;
        return this;
    }

    public ProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public String toString() {
        return super.toString() + "{future=" + this.future + ", localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ", attachments=" + this.attachments + ", stopWatch=" + this.stopWatch + ", providerSide=" + this.providerSide + ", providerInfo=" + this.providerInfo + '}';
    }

    public RpcInternalContext clone() {
        try {
            return (RpcInternalContext)super.clone();
        }
        catch (Exception e) {
            RpcInternalContext context = new RpcInternalContext();
            context.future = this.future;
            context.localAddress = this.localAddress;
            context.remoteAddress = this.remoteAddress;
            context.stopWatch = this.stopWatch.clone();
            context.providerSide = this.providerSide;
            context.providerInfo = this.providerInfo;
            context.attachments.putAll(this.attachments);
            return context;
        }
    }

    public static boolean isValidInternalParamKey(String key) {
        char c = key.charAt(0);
        return c == '_' || c == '.';
    }

    static boolean isHiddenParamKey(String key) {
        char c = key.charAt(0);
        return c == '.';
    }
}

