/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.util.regex.Pattern;

public class ConfigValueHelper {
    protected static final Pattern NORMAL = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.]+$");
    protected static final Pattern NORMAL_COMMA = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.,]+$");
    protected static final Pattern NORMAL_COLON = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.:]+$");
    protected static final Pattern NORMAL_SEMICOLON = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.;]+$");
    protected static final Pattern NORMAL_COMMA_COLON = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.,:]+$");
    protected static final Pattern NORMAL_SEMICOLON_COLON = Pattern.compile("^[a-zA-Z0-9\\-\\_\\.;:]+$");

    protected static boolean assertFalse(String string) {
        return string == null || "".equals(string) || "false".equalsIgnoreCase(string) || "null".equals(string);
    }

    protected static boolean match(Pattern pattern, String configValue) {
        return pattern.matcher(configValue).find();
    }

    protected static void checkNormal(String configKey, String configValue) throws SofaRpcRuntimeException {
        ConfigValueHelper.checkPattern(configKey, configValue, NORMAL, "only allow a-zA-Z0-9 '-' '_' '.'");
    }

    protected static void checkNormalWithComma(String configKey, String configValue) throws SofaRpcRuntimeException {
        ConfigValueHelper.checkPattern(configKey, configValue, NORMAL_COMMA, "only allow a-zA-Z0-9 '-' '_' '.' ','");
    }

    protected static void checkNormalWithColon(String configKey, String configValue) throws SofaRpcRuntimeException {
        ConfigValueHelper.checkPattern(configKey, configValue, NORMAL_COLON, "only allow a-zA-Z0-9 '-' '_' '.' ':'");
    }

    protected static void checkNormalWithCommaColon(String configKey, String configValue) throws SofaRpcRuntimeException {
        ConfigValueHelper.checkPattern(configKey, configValue, NORMAL_COMMA_COLON, "only allow a-zA-Z0-9 '-' '_' '.' ':' ','");
    }

    protected static void checkPattern(String configKey, String configValue, Pattern pattern, String message) throws SofaRpcRuntimeException {
        if (configValue != null && !ConfigValueHelper.match(pattern, configValue)) {
            throw ExceptionUtils.buildRuntime(configKey, configValue, message);
        }
    }

    protected static void checkPositiveInteger(String configKey, int configValue) throws SofaRpcRuntimeException {
        if (configValue <= 0) {
            throw ExceptionUtils.buildRuntime(configKey, configValue + "", "must > 0");
        }
    }

    protected static void checkNotNegativeInteger(String configKey, int configValue) throws SofaRpcRuntimeException {
        if (configValue < 0) {
            throw ExceptionUtils.buildRuntime(configKey, configValue + "", "must >= 0");
        }
    }
}

