/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.dubbo;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.dubbo.DubboConvertor;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Extension(value="dubbo")
public class DubboConsumerBootstrap<T>
extends ConsumerBootstrap<T> {
    private ReferenceConfig<T> referenceConfig;
    protected volatile transient T proxyIns;
    private static final String VERSION = "version";

    protected DubboConsumerBootstrap(ConsumerConfig<T> consumerConfig) {
        super(consumerConfig);
    }

    @Override
    public synchronized T refer() {
        if (this.proxyIns != null) {
            return this.proxyIns;
        }
        this.referenceConfig = new ReferenceConfig();
        this.covert(this.consumerConfig, this.referenceConfig);
        this.proxyIns = this.referenceConfig.get();
        return this.proxyIns;
    }

    private void covert(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        this.copyCommon(consumerConfig, referenceConfig);
        this.copyApplication(consumerConfig, referenceConfig);
        DubboConvertor.copyRegistries(consumerConfig, referenceConfig);
        this.copyConsumer(consumerConfig, referenceConfig);
        this.copyMethods(consumerConfig, referenceConfig);
    }

    private void copyCommon(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        referenceConfig.setInjvm(Boolean.valueOf(consumerConfig.isInJVM()));
    }

    private void copyApplication(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        ApplicationConfig applicationConfig = consumerConfig.getApplication();
        com.alibaba.dubbo.config.ApplicationConfig dubboConfig = new com.alibaba.dubbo.config.ApplicationConfig();
        dubboConfig.setName(applicationConfig.getAppName());
        referenceConfig.setApplication(dubboConfig);
    }

    private void copyConsumer(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        referenceConfig.setId(consumerConfig.getId());
        referenceConfig.setInterface(consumerConfig.getInterfaceId());
        referenceConfig.setGroup(consumerConfig.getUniqueId());
        if (consumerConfig.getParameters() != null && consumerConfig.getParameters().containsKey(VERSION)) {
            referenceConfig.setVersion(consumerConfig.getParameter(VERSION));
        } else {
            referenceConfig.setVersion("1.0");
        }
        referenceConfig.setActives(Integer.valueOf(consumerConfig.getConcurrents()));
        referenceConfig.setCluster(consumerConfig.getCluster());
        referenceConfig.setConnections(Integer.valueOf(consumerConfig.getConnectionNum()));
        referenceConfig.setRetries(Integer.valueOf(consumerConfig.getRetries()));
        referenceConfig.setProxy(consumerConfig.getProxy());
        referenceConfig.setTimeout(Integer.valueOf(consumerConfig.getTimeout()));
        referenceConfig.setUrl(consumerConfig.getDirectUrl());
        referenceConfig.setCheck(Boolean.valueOf(consumerConfig.isCheck()));
        referenceConfig.setLazy(Boolean.valueOf(consumerConfig.isLazy()));
        referenceConfig.setGeneric(Boolean.valueOf(consumerConfig.isGeneric()));
        String invokeType = consumerConfig.getInvokeType();
        if (invokeType != null) {
            if ("oneway".equals(invokeType)) {
                referenceConfig.setSent(Boolean.valueOf(false));
            }
            if ("callback".equals(invokeType) || "future".equals(invokeType)) {
                referenceConfig.setAsync(Boolean.valueOf(true));
            }
        }
        referenceConfig.setParameters(consumerConfig.getParameters());
    }

    private void copyMethods(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        Map<String, MethodConfig> methodConfigs = consumerConfig.getMethods();
        if (CommonUtils.isNotEmpty(methodConfigs)) {
            ArrayList<com.alibaba.dubbo.config.MethodConfig> dubboMethodConfigs = new ArrayList<com.alibaba.dubbo.config.MethodConfig>();
            for (Map.Entry<String, MethodConfig> entry : methodConfigs.entrySet()) {
                MethodConfig methodConfig = entry.getValue();
                com.alibaba.dubbo.config.MethodConfig dubboMethodConfig = new com.alibaba.dubbo.config.MethodConfig();
                dubboMethodConfig.setName(methodConfig.getName());
                dubboMethodConfig.setParameters(methodConfig.getParameters());
                dubboMethodConfig.setTimeout(methodConfig.getTimeout());
                dubboMethodConfig.setRetries(methodConfig.getRetries());
                String invokeType = methodConfig.getInvokeType();
                if (invokeType != null) {
                    if ("oneway".equals(invokeType)) {
                        dubboMethodConfig.setReturn(Boolean.valueOf(false));
                    }
                    if ("callback".equals(invokeType) || "future".equals(invokeType)) {
                        dubboMethodConfig.setAsync(Boolean.valueOf(true));
                    }
                }
                dubboMethodConfigs.add(dubboMethodConfig);
            }
            referenceConfig.setMethods(dubboMethodConfigs);
        }
    }

    @Override
    public synchronized void unRefer() {
        if (this.proxyIns == null) {
            return;
        }
        this.referenceConfig.destroy();
        this.proxyIns = null;
    }

    @Override
    public Cluster getCluster() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<ProviderGroup> subscribe() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isSubscribed() {
        return this.proxyIns != null;
    }

    @Override
    public T getProxyIns() {
        return this.proxyIns;
    }
}

