/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.test;

import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.integration.RegistryApplication;
import com.alipay.sofa.registry.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ConfigurableApplicationContext;

public class TestRegistryMain {
    public static final String LOCAL_ADDRESS = NetUtil.getLocalAddress().getHostAddress();
    private Map<String, String> configs = new HashMap<String, String>();

    public TestRegistryMain() {
        this.configs.put("nodes.metaNode", "DefaultDataCenter:" + LOCAL_ADDRESS);
        this.configs.put("nodes.localDataCenter", "DefaultDataCenter");
        this.configs.put("nodes.localRegion", "DEFAULT_ZONE");
    }

    public void startRegistry() throws Exception {
        for (Map.Entry<String, String> entry : this.configs.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        FileUtils.forceDelete((File)new File(System.getProperty("user.home") + File.separator + "raftData"));
        RegistryApplication.main((String[])new String[0]);
        Thread.sleep(3000L);
    }

    public void stopRegistry() throws Exception {
        RegistryApplication.stop();
    }

    public void startRegistryWithConfig(Map<String, String> configs) throws Exception {
        this.configs.putAll(configs);
        this.startRegistry();
    }

    public ConfigurableApplicationContext getMetaApplicationContext() {
        return RegistryApplication.getMetaApplicationContext();
    }

    public ConfigurableApplicationContext getSessionApplicationContext() {
        return RegistryApplication.getSessionApplicationContext();
    }

    public ConfigurableApplicationContext getDataApplicationContext() {
        return RegistryApplication.getDataApplicationContext();
    }
}

