/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.handler;

import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;

public class RaftClientConnectionHandler
implements ChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftClientConnectionHandler.class);
    private RaftClient raftClient;

    public RaftClientConnectionHandler(RaftClient raftClient) {
        this.raftClient = raftClient;
    }

    public void connected(Channel channel) {
        if (channel != null && channel.isConnected()) {
            LOGGER.info("Raft Client connected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    public void disconnected(Channel channel) {
        if (channel != null && !channel.isConnected()) {
            LOGGER.info("Raft Client disconnected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
        if (RouteTable.getInstance().updateLeader(this.raftClient.getGroupId(), (PeerId)null)) {
            LOGGER.info("Reset leader for raft group {}", (Object)this.raftClient.getGroupId());
        }
    }

    public void received(Channel channel, Object message) {
    }

    public Object reply(Channel channel, Object message) {
        return null;
    }

    public void caught(Channel channel, Object message, Throwable exception) {
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.LISENTER;
    }

    public Class interest() {
        return null;
    }
}

