/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.bootstrap;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.RpcOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.jraft.rpc.impl.cli.BoltCliClientService;
import com.alipay.sofa.registry.jraft.command.ProcessRequest;
import com.alipay.sofa.registry.jraft.command.ProcessResponse;
import com.alipay.sofa.registry.jraft.handler.NotifyLeaderChangeHandler;
import com.alipay.sofa.registry.jraft.handler.RaftClientConnectionHandler;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.ConnectionEventAdapter;
import com.alipay.sofa.registry.remoting.bolt.SyncUserProcessorAdapter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RaftClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftClient.class);
    private BoltCliClientService cliClientService;
    private RpcClient rpcClient;
    private CliOptions cliOptions;
    private String groupId;
    private Configuration conf;
    private AtomicBoolean started = new AtomicBoolean(false);

    public RaftClient(String groupId, String confStr) {
        this.groupId = groupId;
        this.conf = new Configuration();
        if (!this.conf.parse(confStr)) {
            throw new IllegalArgumentException("Fail to parse conf:" + confStr);
        }
        this.cliOptions = new CliOptions();
        this.cliClientService = new BoltCliClientService();
    }

    public RaftClient(String groupId, String confStr, AbstractBoltClientService cliClientService) {
        this.groupId = groupId;
        this.conf = new Configuration();
        if (!this.conf.parse(confStr)) {
            throw new IllegalArgumentException("Fail to parse conf:" + confStr);
        }
        this.cliOptions = new CliOptions();
        this.cliClientService = (BoltCliClientService)cliClientService;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            RouteTable.getInstance().updateConfiguration(this.groupId, this.conf);
            this.cliClientService.init((RpcOptions)this.cliOptions);
            this.rpcClient = this.cliClientService.getRpcClient();
            RaftClientConnectionHandler raftClientConnectionHandler = new RaftClientConnectionHandler(this);
            this.rpcClient.addConnectionEventProcessor(ConnectionEventType.CONNECT, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CONNECT, (ChannelHandler)raftClientConnectionHandler, null));
            this.rpcClient.addConnectionEventProcessor(ConnectionEventType.CLOSE, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.CLOSE, (ChannelHandler)raftClientConnectionHandler, null));
            this.rpcClient.addConnectionEventProcessor(ConnectionEventType.EXCEPTION, (ConnectionEventProcessor)new ConnectionEventAdapter(ConnectionEventType.EXCEPTION, (ChannelHandler)raftClientConnectionHandler, null));
            NotifyLeaderChangeHandler notifyLeaderChangeHandler = new NotifyLeaderChangeHandler(this.groupId, (CliClientService)this.cliClientService);
            this.rpcClient.registerUserProcessor((UserProcessor)new SyncUserProcessorAdapter((ChannelHandler)notifyLeaderChangeHandler));
        }
    }

    public void shutdown() {
        if (this.cliClientService != null) {
            this.cliClientService.shutdown();
        }
    }

    public PeerId refreshLeader() {
        return RaftClient.refreshLeader((CliClientService)this.cliClientService, this.groupId, this.cliOptions.getRpcDefaultTimeout());
    }

    public static PeerId refreshLeader(CliClientService cliClientService, String groupId, int timeout) {
        try {
            Status status = RouteTable.getInstance().refreshLeader(cliClientService, groupId, timeout);
            if (!status.isOk()) {
                throw new IllegalStateException(String.format("Refresh leader failed,error=%s", status.getErrorMsg()));
            }
            PeerId leader = RouteTable.getInstance().selectLeader(groupId);
            LOGGER.info("Leader is {}", (Object)leader);
            status = RouteTable.getInstance().refreshConfiguration(cliClientService, groupId, timeout);
            if (!status.isOk()) {
                throw new IllegalStateException(String.format("Refresh configuration failed, error=%s", status.getErrorMsg()));
            }
            return leader;
        }
        catch (Exception e) {
            LOGGER.error("Refresh leader failed", (Throwable)e);
            throw new IllegalStateException("Refresh leader failed", e);
        }
    }

    public PeerId getLeader() {
        PeerId leader = RouteTable.getInstance().selectLeader(this.groupId);
        if (leader == null) {
            leader = this.refreshLeader();
        }
        return leader;
    }

    public Object sendRequest(ProcessRequest request) {
        try {
            if (!this.started.get()) {
                LOGGER.error("Client must be started before send request!");
                throw new IllegalStateException("Client must be started before send request!");
            }
            PeerId peer = this.getLeader();
            LOGGER.info("Raft client send message {} to url {}", (Object)request, (Object)peer.getEndpoint().toString());
            Object response = this.rpcClient.invokeSync(peer.getEndpoint().toString(), (Object)request, this.cliOptions.getRpcDefaultTimeout());
            if (response == null) {
                LOGGER.error("Send process request has no response return!");
                throw new RuntimeException("Send process request has no response return!");
            }
            ProcessResponse cmd = (ProcessResponse)response;
            if (cmd.getSuccess().booleanValue()) {
                return cmd.getEntity();
            }
            String redirect = cmd.getRedirect();
            if (redirect != null && !redirect.isEmpty()) {
                return this.redirectRequest(request, redirect);
            }
            throw new IllegalStateException("Server error:" + cmd.getEntity());
        }
        catch (Exception e) {
            LOGGER.error("Send process request error!", (Throwable)e);
            throw new RuntimeException("Send process request error!" + e.getMessage(), e);
        }
    }

    private Object redirectRequest(ProcessRequest request, String redirect) {
        try {
            PeerId redirectLead = new PeerId();
            if (!redirectLead.parse(redirect)) {
                throw new IllegalArgumentException("Fail to parse serverId:" + redirect);
            }
            TimeUnit.MILLISECONDS.sleep(1000L);
            LOGGER.info("Redirect request send to return peer {},request {}", (Object)redirect, (Object)request);
            Object response = this.rpcClient.invokeSync(redirectLead.getEndpoint().toString(), (Object)request, this.cliOptions.getRpcDefaultTimeout());
            ProcessResponse cmd = (ProcessResponse)response;
            if (cmd.getSuccess().booleanValue()) {
                RouteTable.getInstance().updateLeader(this.groupId, redirectLead);
                return cmd.getEntity();
            }
            this.refreshLeader();
            throw new IllegalStateException("Redirect request server error:" + cmd.getEntity());
        }
        catch (Exception e) {
            LOGGER.error("Redirect process request error!", (Throwable)e);
            throw new RuntimeException("Redirect process request error!" + e.getMessage(), e);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }
}

