/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.RegisterResponse;
import com.alipay.sofa.registry.core.model.SubscriberRegister;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.bolt.BoltChannelUtil;
import com.alipay.sofa.registry.server.session.converter.SubscriberConverter;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.strategy.SubscriberHandlerStrategy;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultSubscriberHandlerStrategy
implements SubscriberHandlerStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSubscriberHandlerStrategy.class);
    @Autowired
    private Registry sessionRegistry;

    @Override
    public void handleSubscriberRegister(Channel channel, SubscriberRegister subscriberRegister, RegisterResponse registerResponse) {
        try {
            String ip = channel.getRemoteAddress().getAddress().getHostAddress();
            int port = channel.getRemoteAddress().getPort();
            subscriberRegister.setIp(ip);
            subscriberRegister.setPort(Integer.valueOf(port));
            if (StringUtils.isBlank((String)subscriberRegister.getZone())) {
                subscriberRegister.setZone("DEFAULT_ZONE");
            }
            if (StringUtils.isBlank((String)subscriberRegister.getInstanceId())) {
                subscriberRegister.setInstanceId("DEFAULT_INSTANCE_ID");
            }
            Subscriber subscriber = SubscriberConverter.convert(subscriberRegister);
            subscriber.setProcessId(ip + ":" + port);
            subscriber.setSourceAddress(new URL(channel.getRemoteAddress(), BoltChannelUtil.getBoltCustomSerializer((Channel)channel)));
            if ("REGISTER".equals(subscriberRegister.getEventType())) {
                this.sessionRegistry.register((StoreData<String>)subscriber);
            } else if ("UNREGISTER".equals(subscriberRegister.getEventType())) {
                this.sessionRegistry.unRegister((StoreData<String>)subscriber);
            }
            registerResponse.setVersion(subscriberRegister.getVersion().longValue());
            registerResponse.setRegistId(subscriberRegister.getRegistId());
            LOGGER.info("Subscriber register success! Type:{} Info:{}", (Object)subscriberRegister.getEventType(), (Object)subscriber);
            registerResponse.setSuccess(true);
            registerResponse.setMessage("Subscriber register success!");
        }
        catch (Exception e) {
            LOGGER.error("Subscriber register error!Type{}", (Object)subscriberRegister.getEventType(), (Object)e);
            registerResponse.setSuccess(false);
            registerResponse.setMessage("Subscriber register failed!");
        }
    }
}

