/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.core.model.ReceivedConfigData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.node.service.MetaNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class WatcherRegisterFetchTask
extends AbstractSessionTask {
    private static final Logger taskLogger = LoggerFactory.getLogger(WatcherRegisterFetchTask.class, (String)"[Task]");
    private final SessionServerConfig sessionServerConfig;
    private final TaskListenerManager taskListenerManager;
    private final MetaNodeService metaNodeService;
    private Watcher watcher;

    public WatcherRegisterFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, MetaNodeService metaNodeService) {
        this.sessionServerConfig = sessionServerConfig;
        this.taskListenerManager = taskListenerManager;
        this.metaNodeService = metaNodeService;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof Watcher)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.watcher = (Watcher)obj;
    }

    public void execute() {
        if (this.watcher == null) {
            throw new IllegalArgumentException("watcher can not be null!");
        }
        List<String> subscriberRegisterIdList = Collections.singletonList(this.watcher.getRegisterId());
        boolean isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)this.watcher.getClientVersion());
        ProvideData provideData = this.metaNodeService.fetchData(this.watcher.getDataInfoId());
        if (provideData != null && !isOldVersion) {
            DataInfo dataInfo = DataInfo.valueOf((String)provideData.getDataInfoId());
            ReceivedConfigData receivedConfigData = ReceivedDataConverter.getReceivedConfigData(provideData.getProvideData(), dataInfo, provideData.getVersion());
            receivedConfigData.setConfiguratorRegistIds(subscriberRegisterIdList);
            this.firePushTask(receivedConfigData);
        }
    }

    private void firePushTask(ReceivedConfigData receivedConfigData) {
        HashMap<ReceivedConfigData, URL> parameter = new HashMap<ReceivedConfigData, URL>();
        parameter.put(receivedConfigData, this.watcher.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_CONFIG_PUSH_TASK);
        taskLogger.info("send " + taskEvent.getTaskType() + " taskEvent:{}", (Object)taskEvent);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getSubscriberRegisterFetchRetryTimes());
    }

    public String toString() {
        return "WATCHER_REGISTER_FETCH_TASK{taskId='" + this.getTaskId() + '\'' + ", watcher=" + this.watcher + ", retryTimes='" + this.sessionServerConfig.getSubscriberRegisterFetchRetryTimes() + '\'' + '}';
    }
}

