/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.strategy.SubscriberRegisterFetchTaskStrategy;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;

public class SubscriberRegisterFetchTask
extends AbstractSessionTask {
    private final SessionServerConfig sessionServerConfig;
    private final TaskListenerManager taskListenerManager;
    private final DataNodeService dataNodeService;
    private final CacheService sessionCacheService;
    private final SubscriberRegisterFetchTaskStrategy subscriberRegisterFetchTaskStrategy;
    private Subscriber subscriber;

    public SubscriberRegisterFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, DataNodeService dataNodeService, CacheService sessionCacheService, SubscriberRegisterFetchTaskStrategy subscriberRegisterFetchTaskStrategy) {
        this.sessionServerConfig = sessionServerConfig;
        this.taskListenerManager = taskListenerManager;
        this.dataNodeService = dataNodeService;
        this.sessionCacheService = sessionCacheService;
        this.subscriberRegisterFetchTaskStrategy = subscriberRegisterFetchTaskStrategy;
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof Subscriber)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.subscriber = (Subscriber)obj;
    }

    public void execute() {
        this.subscriberRegisterFetchTaskStrategy.doSubscriberRegisterFetchTask(this.sessionServerConfig, this.taskListenerManager, this.dataNodeService, this.sessionCacheService, this.subscriber);
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getSubscriberRegisterFetchRetryTimes());
    }

    public String toString() {
        return "SUBSCRIBER_REGISTER_FETCH_TASK{taskId='" + this.getTaskId() + '\'' + ", subscriber=" + this.subscriber + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }
}

