/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.task;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.SessionNodeService;
import com.alipay.sofa.registry.server.meta.task.AbstractMetaServerTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.util.Map;

public class SessionNodeChangePushTask
extends AbstractMetaServerTask {
    private final SessionNodeService sessionNodeService;
    private final MetaServerConfig metaServerConfig;
    private NodeChangeResult nodeChangeResult;
    private Map<String, SessionNode> targetNodes;
    private String confirmNodeIp;

    public SessionNodeChangePushTask(MetaServerConfig metaServerConfig) {
        this.metaServerConfig = metaServerConfig;
        this.sessionNodeService = (SessionNodeService)ServiceFactory.getNodeService(Node.NodeType.SESSION);
    }

    public void execute() {
        this.sessionNodeService.pushSessions(this.nodeChangeResult, this.targetNodes, this.confirmNodeIp);
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        this.targetNodes = (Map)taskEvent.getAttribute("PUSH_TARGET_SESSION_NODE");
        this.confirmNodeIp = (String)taskEvent.getAttribute("PUSH_TARGET_CONFIRM_NODE");
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof NodeChangeResult)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.nodeChangeResult = (NodeChangeResult)obj;
    }

    public String toString() {
        return "SESSION_NODE_CHANGE_PUSH_TASK{taskId='" + this.taskId + '\'' + ", nodeChangeResult=" + this.nodeChangeResult + '}';
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.metaServerConfig.getSessionNodeChangePushTaskRetryTimes());
    }
}

