/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEventHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.SessionServerDisconnectEvent;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionServerConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionServerConnectionFactory.class);
    private static final int DELAY = 30000;
    private final Map<String, Pair> MAP = new ConcurrentHashMap<String, Pair>();
    private final Map<String, String> PROCESSID_MAP = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> PROCESSID_CLIENT_MAP = new ConcurrentHashMap<String, Set<String>>();
    @Autowired
    private DisconnectEventHandler disconnectEventHandler;

    public void register(String processId, Set<String> clientHosts, Connection connection) {
        String serverHost = NetUtil.toAddressString((InetSocketAddress)connection.getRemoteAddress());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("session({}, processId={}) registered", (Object)serverHost, (Object)processId);
        }
        this.MAP.put(processId, new Pair(serverHost, connection));
        Set ret = this.PROCESSID_CLIENT_MAP.getOrDefault(processId, null);
        if (ret == null) {
            this.PROCESSID_CLIENT_MAP.putIfAbsent(processId, new HashSet());
        }
        this.PROCESSID_CLIENT_MAP.get(processId).addAll(clientHosts);
        this.PROCESSID_MAP.put(serverHost, processId);
    }

    public void registerClient(String processId, String clientAddress) {
        Set ret = this.PROCESSID_CLIENT_MAP.getOrDefault(processId, null);
        if (ret == null) {
            this.PROCESSID_CLIENT_MAP.putIfAbsent(processId, new HashSet());
        }
        this.PROCESSID_CLIENT_MAP.get(processId).add(clientAddress);
    }

    public void removeProcess(String sessionServerHost) {
        String processId = this.PROCESSID_MAP.remove(sessionServerHost);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("session({}, processId={}) unregistered", (Object)sessionServerHost, (Object)processId);
        }
        if (processId != null) {
            this.disconnectEventHandler.receive(new SessionServerDisconnectEvent(processId, sessionServerHost, 30000));
        }
    }

    public Set<String> removeClients(String processId) {
        return this.PROCESSID_CLIENT_MAP.remove(processId);
    }

    public boolean removeProcessIfMatch(String processId, String sessionServerHost) {
        return this.MAP.remove(processId, new Pair(sessionServerHost, null));
    }

    public List<Connection> getConnections() {
        return this.MAP.size() <= 0 ? Collections.EMPTY_LIST : this.MAP.values().stream().map(rec$ -> ((Pair)rec$).getConnection()).collect(Collectors.toList());
    }

    private static class Pair {
        private String sessionServerHost;
        private Connection connection;

        private Pair(String sessionServerHost, Connection connection) {
            this.sessionServerHost = sessionServerHost;
            this.connection = connection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return this.sessionServerHost.equals(pair.sessionServerHost);
        }

        public int hashCode() {
            return this.sessionServerHost.hashCode();
        }

        private Connection getConnection() {
            return this.connection;
        }
    }
}

