/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver.handler;

import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.SyncData;
import com.alipay.sofa.registry.common.model.dataserver.SyncDataRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.datasync.SyncDataService;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncDataHandler
extends AbstractServerHandler<SyncDataRequest> {
    @Autowired
    private SyncDataService syncDataService;

    @Override
    public void checkParam(SyncDataRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getDataInfoId(), (String)"request.dataInfoId");
        ParaCheckUtil.checkNotBlank((String)request.getDataCenter(), (String)"request.dataCenter");
        ParaCheckUtil.checkNotBlank((String)String.valueOf(request.getVersion()), (String)"request.currentVersion");
    }

    @Override
    public Object doHandle(Channel channel, SyncDataRequest request) {
        SyncData syncData = this.syncDataService.getSyncDataChange(request);
        return new GenericResponse().fillSucceed((Object)syncData);
    }

    public GenericResponse<SyncData> buildFailedResponse(String msg) {
        return new GenericResponse().fillFailed(msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return SyncDataRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

