/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.datasync.sync;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.SyncData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.datasync.Operator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Acceptor {
    static final int DEFAULT_DURATION_SECS = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(Acceptor.class, (String)"[SyncDataService]");
    private final Deque<Long> logOperatorsOrder = new ConcurrentLinkedDeque<Long>();
    private final String dataInfoId;
    private final String dataCenter;
    private int maxBufferSize;
    private Map<Long, Operator> logOperators = new ConcurrentHashMap<Long, Operator>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();

    public Acceptor(int maxBufferSize, String dataInfoId, String dataCenter) {
        this.maxBufferSize = maxBufferSize;
        this.dataInfoId = dataInfoId;
        this.dataCenter = dataCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendOperator(Operator operator) {
        this.write.lock();
        try {
            Operator previousOperator;
            Long tailVersion;
            if (this.isFull()) {
                this.logOperators.remove(this.logOperatorsOrder.poll());
            }
            if (operator.getSourceVersion() == null) {
                operator.setSourceVersion(0L);
            }
            if ((tailVersion = this.logOperatorsOrder.peekLast()) != null && tailVersion.longValue() != operator.getSourceVersion().longValue()) {
                LOGGER.warn("Datum {} append operation not follow version sequence!Current version {},but input source version {}.In order to avoid get data error clear operations!", new Object[]{operator.getDatum().getDataInfoId(), tailVersion, operator.getSourceVersion()});
                this.clearBefore();
            }
            if ((previousOperator = this.logOperators.put(operator.getVersion(), operator)) == null) {
                this.logOperatorsOrder.add(operator.getVersion());
            } else {
                LOGGER.warn("Append operation has been exist!");
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public Collection<Operator> getAllOperators() {
        LinkedList<Operator> linkRet = new LinkedList<Operator>();
        if (this.logOperatorsOrder.peek() != null) {
            for (Long i : this.logOperatorsOrder) {
                linkRet.add(this.logOperators.get(i));
            }
        }
        return linkRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncData process(Long currentVersion) {
        this.read.lock();
        try {
            SyncData syncData;
            Collection<Operator> operators = this.acceptOperator(currentVersion);
            LinkedList<Datum> retList = new LinkedList<Datum>();
            boolean wholeDataTag = false;
            if (operators != null) {
                if (operators.isEmpty()) {
                    wholeDataTag = true;
                    retList.add(DatumCache.get(this.dataCenter, this.dataInfoId));
                    LOGGER.info("Get all data!dataInfoID:{} dataCenter:{}.All data size{}:", new Object[]{this.dataInfoId, this.dataCenter, retList.size()});
                } else {
                    for (Operator operator : operators) {
                        retList.add(operator.getDatum());
                    }
                }
                syncData = new SyncData(this.dataInfoId, this.dataCenter, wholeDataTag, retList);
            } else {
                LOGGER.info("Append log queue is empty,Maybe all logs record expired or no operator append!So must get all data!dataInfoID:{} dataCenter:{}.queue size{}:", new Object[]{this.dataInfoId, this.dataCenter, this.logOperatorsOrder.size()});
                wholeDataTag = true;
                retList.add(DatumCache.get(this.dataCenter, this.dataInfoId));
                syncData = new SyncData(this.dataInfoId, this.dataCenter, wholeDataTag, retList);
            }
            SyncData syncData2 = syncData;
            return syncData2;
        }
        finally {
            this.read.unlock();
        }
    }

    public Collection<Operator> acceptOperator(Long currentVersion) {
        if (currentVersion == null) {
            LOGGER.info("Current version input is null,maybe first get all data!dataInfoID:{} dataCenter:{}", (Object)this.dataInfoId, (Object)this.dataCenter);
            return new ArrayList<Operator>();
        }
        if (this.logOperatorsOrder.size() > 0) {
            LinkedList<Operator> linkRet = new LinkedList<Operator>();
            if (this.logOperatorsOrder.contains(currentVersion)) {
                Long i;
                Iterator<Long> iterator = this.logOperatorsOrder.descendingIterator();
                while (iterator.hasNext() && !currentVersion.equals(i = iterator.next())) {
                    linkRet.addFirst(this.logOperators.get(i));
                }
            } else {
                Operator headOperator = this.logOperators.get(this.logOperatorsOrder.peek());
                if (currentVersion.equals(headOperator.getSourceVersion())) {
                    LOGGER.info("current version not found on queue,but header source version equals current version!");
                    linkRet.addAll(this.logOperators.values());
                }
            }
            if (linkRet.isEmpty()) {
                LOGGER.info("Current version {} not match on queue,queue size {} !", (Object)currentVersion, (Object)this.logOperatorsOrder.size());
            }
            return linkRet;
        }
        return null;
    }

    public void checkExpired(int durationSEC) {
        this.write.lock();
        try {
            Long peekVersion = this.logOperatorsOrder.peek();
            if (peekVersion != null && this.isExpired(durationSEC, peekVersion)) {
                this.logOperators.remove(this.logOperatorsOrder.poll());
                this.checkExpired(durationSEC);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public Long getLastVersion() {
        return this.logOperatorsOrder.peekLast();
    }

    private boolean isFull() {
        return this.logOperators.size() >= this.maxBufferSize;
    }

    private boolean isExpired(int durationSECS, long peekVersion) {
        boolean ret;
        durationSECS = durationSECS > 0 ? durationSECS * 1000 : 30000;
        boolean bl = ret = System.currentTimeMillis() > peekVersion + (long)durationSECS;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("now:" + System.currentTimeMillis() + " peek:" + peekVersion + " du:" + durationSECS + " result:" + ret);
        }
        return ret;
    }

    private void clearBefore() {
        this.write.lock();
        try {
            this.logOperators.clear();
            this.logOperatorsOrder.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    public void printInfo() {
        LOGGER.debug("----------------------------------------------------------------------------");
        LOGGER.debug("Acceptor info has " + this.logOperators.size() + " operations\uff0cdataInfoID:" + this.getDataInfoId() + " dataCenter:" + this.getDataCenter());
        if (this.logOperatorsOrder.size() > 0) {
            for (Long version : this.logOperatorsOrder) {
                Operator operator = this.logOperators.get(version);
                LOGGER.debug("| " + this.pidLine(String.valueOf(operator.getVersion()), 24, " ") + this.pidLine(String.valueOf(operator.getSourceVersion()), 24, " ") + operator.getDatum());
            }
        }
    }

    private String pidLine(String line, int length, String space) {
        StringBuilder sb = new StringBuilder();
        sb.append(line);
        int spaces = length - line.getBytes(Charset.defaultCharset()).length - 1;
        for (int i = 0; i < spaces; ++i) {
            sb.append(space);
        }
        return sb.toString();
    }

    public String getDataInfoId() {
        return this.dataInfoId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }
}

