/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.server.data.cache.MergeResult;
import com.alipay.sofa.registry.server.data.cache.UnPublisher;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class DatumCache {
    public static final long ERROR_DATUM_VERSION = -2L;
    private static final Map<String, Map<String, Datum>> DATUM_MAP = new ConcurrentHashMap<String, Map<String, Datum>>();
    private static final Map<String, Map<String, Publisher>> CLIENT_PUB_MAP = new ConcurrentHashMap<String, Map<String, Publisher>>();

    public static Datum get(String dataCenter, String dataInfoId) {
        Map<String, Datum> map;
        if (DATUM_MAP.containsKey(dataCenter) && (map = DATUM_MAP.get(dataCenter)).containsKey(dataInfoId)) {
            return map.get(dataInfoId);
        }
        return null;
    }

    public static Map<String, Datum> get(String dataInfoId) {
        HashMap<String, Datum> datumMap = new HashMap<String, Datum>();
        DATUM_MAP.forEach((dataCenter, datums) -> {
            if (datums.containsKey(dataInfoId)) {
                datumMap.put((String)dataCenter, (Datum)datums.get(dataInfoId));
            }
        });
        return datumMap;
    }

    public static Map<String, Datum> getDatumGroupByDataCenter(String dataCenter, String dataInfoId) {
        HashMap<String, Datum> map = new HashMap();
        if (StringUtils.isEmpty((Object)dataCenter)) {
            map = DatumCache.get(dataInfoId);
        } else {
            Datum datum = DatumCache.get(dataCenter, dataInfoId);
            if (datum != null) {
                map.put(dataCenter, datum);
            }
        }
        return map;
    }

    public static Map<String, Map<String, Datum>> getAll() {
        return DATUM_MAP;
    }

    public static Map<String, Publisher> getByHost(String host) {
        return CLIENT_PUB_MAP.getOrDefault(host, null);
    }

    public static MergeResult putDatum(DataChangeTypeEnum changeType, Datum datum) {
        MergeResult mergeResult;
        Object ret;
        String dataCenter = datum.getDataCenter();
        String dataInfoId = datum.getDataInfoId();
        Object map = DATUM_MAP.get(dataCenter);
        if (map == null && (ret = DATUM_MAP.putIfAbsent(dataCenter, (Map<String, Datum>)(map = new ConcurrentHashMap<String, Datum>()))) != null) {
            map = ret;
        }
        if (datum.getDataId() == null && map.get(dataInfoId) == null) {
            MergeResult mergeResult2 = new MergeResult(-2L, false);
            return mergeResult2;
        }
        ret = map.putIfAbsent((String)dataInfoId, (Datum)datum);
        if (ret == null) {
            Set entries = datum.getPubMap().entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Publisher publisher = (Publisher)entry.getValue();
                if (!(publisher instanceof UnPublisher)) {
                    String registerId = publisher.getRegisterId();
                    ConcurrentHashMap<String, Publisher> clientRegisterMap = new ConcurrentHashMap<String, Publisher>();
                    clientRegisterMap.put(registerId, publisher);
                    Map retMap = CLIENT_PUB_MAP.putIfAbsent(publisher.getSourceAddress().getAddressString(), clientRegisterMap);
                    if (retMap == null) continue;
                    retMap.putAll(clientRegisterMap);
                    continue;
                }
                iterator.remove();
            }
            mergeResult = new MergeResult(null, true);
        } else if (changeType == DataChangeTypeEnum.MERGE) {
            mergeResult = DatumCache.mergeDatum(datum);
        } else {
            Long lastVersion = DatumCache.coverDatum(datum);
            mergeResult = new MergeResult(lastVersion, true);
        }
        return mergeResult;
    }

    public static boolean cleanDatum(String dataCenter, String dataInfoId) {
        Datum cacheDatum;
        Map<String, Datum> datumMap = DATUM_MAP.get(dataCenter);
        if (datumMap != null && (cacheDatum = datumMap.remove(dataInfoId)) != null) {
            Map cachePubMap = cacheDatum.getPubMap();
            for (Map.Entry cachePubEntry : cachePubMap.entrySet()) {
                String registerId = (String)cachePubEntry.getKey();
                Publisher cachePub = (Publisher)cachePubEntry.getValue();
                if (cachePub == null) continue;
                cachePubMap.remove(registerId);
                CLIENT_PUB_MAP.get(cachePub.getSourceAddress().getAddressString()).remove(registerId);
            }
            return true;
        }
        return false;
    }

    private static MergeResult mergeDatum(Datum datum) {
        boolean isChanged = false;
        Datum cacheDatum = DATUM_MAP.get(datum.getDataCenter()).get(datum.getDataInfoId());
        Map cachePubMap = cacheDatum.getPubMap();
        Map pubMap = datum.getPubMap();
        for (Map.Entry pubEntry : pubMap.entrySet()) {
            String cachePubAddr;
            String registerId = (String)pubEntry.getKey();
            Publisher pub = (Publisher)pubEntry.getValue();
            Publisher cachePub = (Publisher)cachePubMap.get(registerId);
            if (pub instanceof UnPublisher) {
                if (cachePub == null || pub.getRegisterTimestamp() <= cachePub.getRegisterTimestamp()) continue;
                cachePubMap.remove(registerId);
                CLIENT_PUB_MAP.get(cachePub.getSourceAddress().getAddressString()).remove(registerId);
                isChanged = true;
                continue;
            }
            String pubAddr = pub.getSourceAddress().getAddressString();
            long version = pub.getVersion();
            long cacheVersion = cachePub == null ? 0L : cachePub.getVersion();
            String string = cachePubAddr = cachePub == null ? "" : cachePub.getSourceAddress().getAddressString();
            if (cacheVersion > version) continue;
            cachePubMap.put(registerId, pub);
            if (cacheVersion >= version && pubAddr.equals(cachePubAddr)) continue;
            if (CLIENT_PUB_MAP.containsKey(cachePubAddr)) {
                CLIENT_PUB_MAP.get(cachePubAddr).remove(registerId);
            }
            if (!CLIENT_PUB_MAP.containsKey(pubAddr)) {
                CLIENT_PUB_MAP.putIfAbsent(pubAddr, new ConcurrentHashMap());
            }
            CLIENT_PUB_MAP.get(pubAddr).put(registerId, pub);
            isChanged = true;
        }
        Long lastVersion = cacheDatum.getVersion();
        if (isChanged) {
            cacheDatum.setVersion(datum.getVersion());
        }
        return new MergeResult(lastVersion, isChanged);
    }

    private static Long coverDatum(Datum datum) {
        String dataCenter = datum.getDataCenter();
        String dataInfoId = datum.getDataInfoId();
        Datum cacheDatum = DATUM_MAP.get(dataCenter).get(dataInfoId);
        if (datum.getVersion() != cacheDatum.getVersion()) {
            DATUM_MAP.get(dataCenter).put(dataInfoId, datum);
            Map pubMap = datum.getPubMap();
            HashMap cachePubMap = new HashMap(cacheDatum.getPubMap());
            for (Map.Entry pubEntry : pubMap.entrySet()) {
                String registerId = (String)pubEntry.getKey();
                Publisher pub = (Publisher)pubEntry.getValue();
                String pubAddr = pub.getSourceAddress().getAddressString();
                if (!CLIENT_PUB_MAP.containsKey(pubAddr)) {
                    CLIENT_PUB_MAP.putIfAbsent(pubAddr, new ConcurrentHashMap());
                }
                CLIENT_PUB_MAP.get(pubAddr).put(registerId, pub);
                Publisher cachePub = (Publisher)cachePubMap.get(registerId);
                if (cachePub == null || !pubAddr.equals(cachePub.getSourceAddress().getAddressString())) continue;
                cachePubMap.remove(registerId);
            }
            if (!cachePubMap.isEmpty()) {
                for (Publisher cachePub : cachePubMap.values()) {
                    CLIENT_PUB_MAP.get(cachePub.getSourceAddress().getAddressString()).remove(cachePub.getRegisterId());
                }
            }
        }
        return cacheDatum.getVersion();
    }
}

