/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import java.util.concurrent.Executor;

public class AsyncUserProcessorAdapter
extends AsyncUserProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncUserProcessorAdapter.class);
    private ChannelHandler userProcessorHandler;

    public AsyncUserProcessorAdapter(ChannelHandler userProcessorHandler) {
        this.userProcessorHandler = userProcessorHandler;
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, Object request) {
        BoltChannel boltChannel = new BoltChannel();
        boltChannel.setAsyncContext(asyncCtx);
        boltChannel.setConnection(bizCtx.getConnection());
        try {
            if (this.userProcessorHandler != null) {
                this.userProcessorHandler.received((Channel)boltChannel, request);
            }
        }
        catch (Exception e) {
            LOGGER.error("Handle request error!", (Throwable)e);
            throw new RuntimeException("Handle request error!", e);
        }
    }

    public Object handleRequest(BizContext bizCtx, Object request) throws Exception {
        return super.handleRequest(bizCtx, request);
    }

    public String interest() {
        if (this.userProcessorHandler != null && this.userProcessorHandler.interest() != null) {
            return this.userProcessorHandler.interest().getName();
        }
        return null;
    }

    public Executor getExecutor() {
        return this.userProcessorHandler.getExecutor();
    }
}

