/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.util;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertySplitter {
    public Map<String, String> map(String property) {
        if (property == null) {
            return new HashMap<String, String>();
        }
        return this.map(property, ",");
    }

    public Map<String, Collection<String>> mapOfList(String property) {
        if (property == null) {
            return new HashMap<String, Collection<String>>();
        }
        Map<String, String> map = this.map(property, "|");
        HashMap<String, Collection<String>> mapOfList = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapOfList.put(entry.getKey(), this.list(entry.getValue()));
        }
        return mapOfList;
    }

    public Collection<String> list(String property) {
        if (property == null) {
            return new ArrayList<String>();
        }
        return this.list(property, ",");
    }

    public Collection<Collection<String>> groupedList(String property) {
        if (property == null) {
            return new ArrayList<Collection<String>>();
        }
        Collection<String> unGroupedList = this.list(property, "|");
        ArrayList<Collection<String>> groupedList = new ArrayList<Collection<String>>();
        for (String group : unGroupedList) {
            groupedList.add(this.list(group));
        }
        return groupedList;
    }

    private Collection<String> list(String property, String splitter) {
        return Splitter.on((String)splitter).omitEmptyStrings().trimResults().splitToList((CharSequence)property);
    }

    private Map<String, String> map(String property, String splitter) {
        return Splitter.on((String)splitter).omitEmptyStrings().trimResults().withKeyValueSeparator(":").split((CharSequence)property);
    }
}

