/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.store;

import com.alipay.sofa.registry.common.model.ElementType;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Subscriber
extends BaseInfo {
    private static final long serialVersionUID = 98433360274932292L;
    private ScopeEnum scope;
    private ElementType elementType;
    private Map<String, Long> lastPushVersions = new ConcurrentHashMap<String, Long>();

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean checkVersion(String dataCenter, Long version) {
        Long oldVersion = this.lastPushVersions.get(dataCenter);
        if (oldVersion == null) {
            return version != null;
        }
        if (version != null) {
            return version > oldVersion;
        }
        return false;
    }

    public void checkAndUpdateVersion(String dataCenter, Long version) {
        Long oldVersion;
        while ((oldVersion = this.lastPushVersions.putIfAbsent(dataCenter, version)) != null && version > oldVersion && !this.lastPushVersions.replace(dataCenter, oldVersion, version)) {
        }
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    @Override
    @JsonIgnore
    public StoreData.DataType getDataType() {
        return StoreData.DataType.SUBSCRIBER;
    }

    @Override
    protected String getOtherInfo() {
        StringBuilder sb = new StringBuilder("scope=");
        sb.append(this.scope).append(",");
        sb.append("elementType=").append((Object)this.elementType).append(",");
        sb.append("lastPushVersion=").append(this.lastPushVersions);
        return sb.toString();
    }

    public Map<String, Long> getLastPushVersions() {
        return this.lastPushVersions;
    }

    public void setLastPushVersions(Map<String, Long> lastPushVersions) {
        this.lastPushVersions = lastPushVersions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Subscriber{");
        sb.append("scope=").append(this.scope);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", lastPushVersions=").append(this.lastPushVersions);
        sb.append(", super=").append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

