/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.pipeline.future;

import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.pipeline.future.PipelineFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPipelineFuture<V>
extends CompletableFuture<V>
implements PipelineFuture<V> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPipelineFuture.class);
    private static final long DEFAULT_TIMEOUT_NANOSECONDS = TimeUnit.SECONDS.toNanos(30L);
    private static final ConcurrentMap<Long, DefaultPipelineFuture<?>> futures = Maps.newConcurrentMapLong();
    private final long invokeId;
    private final long timeout;
    private final long startTime = System.nanoTime();

    public static <T> DefaultPipelineFuture<T> with(long invokeId, long timeoutMillis) {
        return new DefaultPipelineFuture(invokeId, timeoutMillis);
    }

    public static void received(long invokeId, Object response) {
        DefaultPipelineFuture future = (DefaultPipelineFuture)futures.remove(invokeId);
        if (future == null) {
            LOG.warn("A timeout response [{}] finally returned.", response);
            return;
        }
        future.doReceived(response);
    }

    private DefaultPipelineFuture(long invokeId, long timeoutMillis) {
        this.invokeId = invokeId;
        this.timeout = timeoutMillis > 0L ? TimeUnit.MILLISECONDS.toNanos(timeoutMillis) : DEFAULT_TIMEOUT_NANOSECONDS;
        futures.put(invokeId, this);
    }

    @Override
    public V getResult() throws Throwable {
        return (V)this.get(this.timeout, TimeUnit.NANOSECONDS);
    }

    private void doReceived(Object response) {
        if (response instanceof Throwable) {
            this.completeExceptionally((Throwable)response);
        } else {
            this.complete(response);
        }
    }

    static {
        Thread t = new Thread((Runnable)new TimeoutScanner(), "timeout.scanner");
        t.setDaemon(true);
        t.start();
    }

    private static class TimeoutScanner
    implements Runnable {
        private TimeoutScanner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        for (DefaultPipelineFuture future : futures.values()) {
                            this.process(future);
                        }
                        Thread.sleep(30L);
                    }
                }
                catch (Throwable t) {
                    LOG.error("An exception has been caught while scanning the timeout futures {}.", t);
                    continue;
                }
                break;
            }
        }

        private void process(DefaultPipelineFuture<?> future) {
            if (future == null || future.isDone()) {
                return;
            }
            if (System.nanoTime() - ((DefaultPipelineFuture)future).startTime > ((DefaultPipelineFuture)future).timeout) {
                DefaultPipelineFuture.received(((DefaultPipelineFuture)future).invokeId, new TimeoutException());
            }
        }
    }
}

