/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.pipeline;

import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerInvoker;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerInvokerUtil;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.InboundMessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.MessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.OutboundMessageEvent;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandlerInvoker
implements HandlerInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHandlerInvoker.class);
    private final ExecutorService executor;

    public DefaultHandlerInvoker() {
        this(null);
    }

    public DefaultHandlerInvoker(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public ExecutorService executor() {
        return this.executor;
    }

    @Override
    public void invokeInbound(HandlerContext ctx, InboundMessageEvent<?> event) {
        if (this.executor == null) {
            HandlerInvokerUtil.invokeInboundNow(ctx, event);
        } else {
            this.executor.execute(() -> HandlerInvokerUtil.invokeInboundNow(ctx, event));
        }
    }

    @Override
    public void invokeOutbound(HandlerContext ctx, OutboundMessageEvent<?> event) {
        if (this.executor == null) {
            HandlerInvokerUtil.invokeOutboundNow(ctx, event);
        } else {
            this.executor.execute(() -> HandlerInvokerUtil.invokeOutboundNow(ctx, event));
        }
    }

    @Override
    public void invokeExceptionCaught(HandlerContext ctx, MessageEvent<?> event, Throwable cause) {
        block5: {
            if (cause == null) {
                throw new NullPointerException("cause");
            }
            if (this.executor == null) {
                HandlerInvokerUtil.invokeExceptionCaughtNow(ctx, event, cause);
            } else {
                try {
                    this.executor.execute(() -> HandlerInvokerUtil.invokeExceptionCaughtNow(ctx, event, cause));
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn("Failed to submit an exceptionCaught() event: {}.", (Object)StackTraceUtil.stackTrace(t));
                    LOG.warn("The exceptionCaught() event that was failed to submit was: {}.", (Object)StackTraceUtil.stackTrace(cause));
                }
            }
        }
    }

    @Override
    public void shutdown() {
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.executor);
    }
}

