/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent.disruptor;

import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.MessageEvent;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.TimeoutHandler;
import com.lmax.disruptor.WorkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandler
implements EventHandler<MessageEvent<Runnable>>,
WorkHandler<MessageEvent<Runnable>>,
TimeoutHandler,
LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(TaskHandler.class);

    public void onEvent(MessageEvent<Runnable> event, long sequence, boolean endOfBatch) throws Exception {
        event.getMessage().run();
    }

    public void onEvent(MessageEvent<Runnable> event) throws Exception {
        event.getMessage().run();
    }

    public void onTimeout(long sequence) throws Exception {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Task timeout on: {}, sequence: {}.", (Object)Thread.currentThread().getName(), (Object)sequence);
        }
    }

    public void onStart() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Task handler on start: {}.", (Object)Thread.currentThread().getName());
        }
    }

    public void onShutdown() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Task handler on shutdown: {}.", (Object)Thread.currentThread().getName());
        }
    }
}

