/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.util.internal.ReferenceFieldUpdater;
import com.alipay.sofa.jraft.rhea.util.internal.Updaters;

public class StringBuilderHelper {
    private static final ReferenceFieldUpdater<StringBuilder, char[]> valueUpdater = Updaters.newReferenceFieldUpdater(StringBuilder.class.getSuperclass(), "value");
    private static final int DISCARD_LIMIT = 8192;
    private static final ThreadLocal<StringBuilderHolder> holderThreadLocal = ThreadLocal.withInitial(() -> new StringBuilderHolder());

    public static StringBuilder get() {
        StringBuilderHolder holder = holderThreadLocal.get();
        return holder.getStringBuilder();
    }

    public static void truncate() {
        StringBuilderHolder holder = holderThreadLocal.get();
        holder.truncate();
    }

    private static class StringBuilderHolder {
        private final StringBuilder buf = new StringBuilder();

        private StringBuilderHolder() {
        }

        private StringBuilder getStringBuilder() {
            this.truncate();
            return this.buf;
        }

        private void truncate() {
            if (this.buf.capacity() > 8192) {
                valueUpdater.set(this.buf, new char[1024]);
            }
            this.buf.setLength(0);
        }
    }
}

