/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.util.BytesUtil;

public final class RegionHelper {
    public static boolean isSingleGroup(Region region) {
        return BytesUtil.nullToEmpty((byte[])region.getStartKey()).length == 0 && BytesUtil.nullToEmpty((byte[])region.getEndKey()).length == 0;
    }

    public static boolean isMultiGroup(Region region) {
        return !RegionHelper.isSingleGroup(region);
    }

    public static boolean isSameRange(Region r1, Region r2) {
        if (BytesUtil.compare((byte[])BytesUtil.nullToEmpty((byte[])r1.getStartKey()), (byte[])BytesUtil.nullToEmpty((byte[])r2.getStartKey())) != 0) {
            return false;
        }
        return BytesUtil.compare((byte[])BytesUtil.nullToEmpty((byte[])r1.getEndKey()), (byte[])BytesUtil.nullToEmpty((byte[])r2.getEndKey())) == 0;
    }

    public static boolean isKeyInRegion(byte[] key, Region region) {
        byte[] startKey = BytesUtil.nullToEmpty((byte[])region.getStartKey());
        if (BytesUtil.compare((byte[])key, (byte[])startKey) < 0) {
            return false;
        }
        byte[] endKey = region.getEndKey();
        return endKey == null || BytesUtil.compare((byte[])key, (byte[])endKey) < 0;
    }

    private RegionHelper() {
    }
}

