/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.NodeExecutor;
import com.alipay.sofa.jraft.rhea.util.Pair;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Requires;
import java.io.Serializable;
import java.util.List;

public class KVOperation
implements Serializable {
    private static final long serialVersionUID = 1368415383186519279L;
    public static final byte MAGIC = 0;
    public static final byte PUT = 1;
    public static final byte PUT_IF_ABSENT = 2;
    public static final byte DELETE = 3;
    public static final byte PUT_LIST = 4;
    public static final byte DELETE_RANGE = 5;
    public static final byte GET_SEQUENCE = 6;
    public static final byte NODE_EXECUTE = 7;
    public static final byte KEY_LOCK = 8;
    public static final byte KEY_LOCK_RELEASE = 9;
    public static final byte GET = 10;
    public static final byte MULTI_GET = 11;
    public static final byte SCAN = 12;
    public static final byte GET_PUT = 13;
    public static final byte MERGE = 14;
    public static final byte RESET_SEQUENCE = 15;
    public static final byte RANGE_SPLIT = 16;
    public static final byte COMPARE_PUT = 17;
    public static final byte DELETE_LIST = 18;
    public static final byte CONTAINS_KEY = 19;
    public static final byte EOF = 20;
    private static final byte[] VALID_OPS = new byte[19];
    private byte[] key;
    private byte[] value;
    private Object attach;
    private byte op;

    public static boolean isValidOp(byte op) {
        return op > 0 && op < 20;
    }

    public static byte[] getValidOps() {
        byte[] copy = new byte[VALID_OPS.length];
        System.arraycopy(VALID_OPS, 0, copy, 0, copy.length);
        return copy;
    }

    public static KVOperation createPut(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        return new KVOperation(key, value, null, 1);
    }

    public static KVOperation createPutIfAbsent(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        return new KVOperation(key, value, null, 2);
    }

    public static KVOperation createDelete(byte[] key) {
        Requires.requireNonNull((Object)key, (String)"key");
        return new KVOperation(key, BytesUtil.EMPTY_BYTES, null, 3);
    }

    public static KVOperation createPutList(List<KVEntry> entries) {
        Requires.requireNonNull(entries, (String)"entries");
        Requires.requireTrue((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries is empty");
        return new KVOperation(BytesUtil.EMPTY_BYTES, BytesUtil.EMPTY_BYTES, entries, 4);
    }

    public static KVOperation createDeleteRange(byte[] startKey, byte[] endKey) {
        Requires.requireNonNull((Object)startKey, (String)"startKey");
        Requires.requireNonNull((Object)endKey, (String)"endKey");
        return new KVOperation(startKey, endKey, null, 5);
    }

    public static KVOperation createDeleteList(List<byte[]> keys) {
        Requires.requireNonNull(keys, (String)"keys");
        Requires.requireTrue((!keys.isEmpty() ? 1 : 0) != 0, (Object)"keys is empty");
        return new KVOperation(BytesUtil.EMPTY_BYTES, BytesUtil.EMPTY_BYTES, keys, 18);
    }

    public static KVOperation createGetSequence(byte[] seqKey, int step) {
        Requires.requireNonNull((Object)seqKey, (String)"seqKey");
        Requires.requireTrue((step > 0 ? 1 : 0) != 0, (Object)"step must > 0");
        return new KVOperation(seqKey, BytesUtil.EMPTY_BYTES, step, 6);
    }

    public static KVOperation createNodeExecutor(NodeExecutor nodeExecutor) {
        return new KVOperation(BytesUtil.EMPTY_BYTES, BytesUtil.EMPTY_BYTES, nodeExecutor, 7);
    }

    public static KVOperation createKeyLockRequest(byte[] key, byte[] fencingKey, Pair<Boolean, DistributedLock.Acquirer> acquirerPair) {
        Requires.requireNonNull((Object)key, (String)"key");
        return new KVOperation(key, fencingKey, acquirerPair, 8);
    }

    public static KVOperation createKeyLockReleaseRequest(byte[] key, DistributedLock.Acquirer acquirer) {
        Requires.requireNonNull((Object)key, (String)"key");
        return new KVOperation(key, BytesUtil.EMPTY_BYTES, acquirer, 9);
    }

    public static KVOperation createGet(byte[] key) {
        Requires.requireNonNull((Object)key, (String)"key");
        return new KVOperation(key, BytesUtil.EMPTY_BYTES, null, 10);
    }

    public static KVOperation createMultiGet(List<byte[]> keys) {
        Requires.requireNonNull(keys, (String)"keys");
        Requires.requireTrue((!keys.isEmpty() ? 1 : 0) != 0, (Object)"keys is empty");
        return new KVOperation(BytesUtil.EMPTY_BYTES, BytesUtil.EMPTY_BYTES, keys, 11);
    }

    public static KVOperation createContainsKey(byte[] key) {
        Requires.requireNonNull((Object)key, (String)"key");
        return new KVOperation(key, BytesUtil.EMPTY_BYTES, null, 19);
    }

    public static KVOperation createScan(byte[] startKey, byte[] endKey, int limit, boolean returnValue) {
        return new KVOperation(startKey, endKey, Pair.of(limit, returnValue), 12);
    }

    public static KVOperation createGetAndPut(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        return new KVOperation(key, value, null, 13);
    }

    public static KVOperation createCompareAndPut(byte[] key, byte[] expect, byte[] update) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)expect, (String)"expect");
        Requires.requireNonNull((Object)update, (String)"update");
        return new KVOperation(key, update, expect, 17);
    }

    public static KVOperation createMerge(byte[] key, byte[] value) {
        Requires.requireNonNull((Object)key, (String)"key");
        Requires.requireNonNull((Object)value, (String)"value");
        return new KVOperation(key, value, null, 14);
    }

    public static KVOperation createResetSequence(byte[] seqKey) {
        Requires.requireNonNull((Object)seqKey, (String)"seqKey");
        return new KVOperation(seqKey, BytesUtil.EMPTY_BYTES, null, 15);
    }

    public static KVOperation createRangeSplit(byte[] splitKey, long currentRegionId, long newRegionId) {
        Requires.requireNonNull((Object)splitKey, (String)"splitKey");
        return new KVOperation(splitKey, BytesUtil.EMPTY_BYTES, Pair.of(currentRegionId, newRegionId), 16);
    }

    public KVOperation() {
    }

    public KVOperation(byte[] key, byte[] value, Object attach, byte op) {
        this.key = key;
        this.value = value;
        this.attach = attach;
        this.op = op;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getStartKey() {
        return this.key;
    }

    public byte[] getSeqKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getEndKey() {
        return this.value;
    }

    public byte[] getFencingKey() {
        return this.value;
    }

    public byte getOp() {
        return this.op;
    }

    public int getStep() {
        return (Integer)this.attach;
    }

    public byte[] getExpect() {
        return (byte[])this.attach;
    }

    public List<KVEntry> getEntries() {
        return (List)this.attach;
    }

    public List<byte[]> getKeys() {
        return (List)this.attach;
    }

    public NodeExecutor getNodeExecutor() {
        return (NodeExecutor)this.attach;
    }

    public Pair<Boolean, DistributedLock.Acquirer> getAcquirerPair() {
        return (Pair)this.attach;
    }

    public DistributedLock.Acquirer getAcquirer() {
        return (DistributedLock.Acquirer)this.attach;
    }

    public List<byte[]> getKeyList() {
        return (List)this.attach;
    }

    public long getCurrentRegionId() {
        return (Long)((Pair)this.attach).getKey();
    }

    public long getNewRegionId() {
        return (Long)((Pair)this.attach).getValue();
    }

    public int getLimit() {
        if (this.attach instanceof Pair) {
            return (Integer)((Pair)this.attach).getKey();
        }
        return (Integer)this.attach;
    }

    public boolean isReturnValue() {
        if (this.attach instanceof Pair) {
            return (Boolean)((Pair)this.attach).getValue();
        }
        return true;
    }

    public static String opName(KVOperation op) {
        return KVOperation.opName(op.op);
    }

    public static String opName(byte op) {
        switch (op) {
            case 1: {
                return "PUT";
            }
            case 2: {
                return "PUT_IF_ABSENT";
            }
            case 3: {
                return "DELETE";
            }
            case 4: {
                return "PUT_LIST";
            }
            case 5: {
                return "DELETE_RANGE";
            }
            case 6: {
                return "GET_SEQUENCE";
            }
            case 7: {
                return "NODE_EXECUTE";
            }
            case 8: {
                return "KEY_LOCK";
            }
            case 9: {
                return "KEY_LOCK_RELEASE";
            }
            case 10: {
                return "GET";
            }
            case 11: {
                return "MULTI_GET";
            }
            case 12: {
                return "SCAN";
            }
            case 13: {
                return "GET_PUT";
            }
            case 17: {
                return "COMPARE_PUT";
            }
            case 14: {
                return "MERGE";
            }
            case 15: {
                return "RESET_SEQUENCE";
            }
            case 16: {
                return "RANGE_SPLIT";
            }
        }
        return "UNKNOWN" + op;
    }

    public String toString() {
        return "KVOperation{key=" + BytesUtil.toHex((byte[])this.key) + ", value=" + BytesUtil.toHex((byte[])this.value) + ", attach=" + this.attach + ", op=" + this.op + '}';
    }

    static {
        KVOperation.VALID_OPS[0] = 1;
        KVOperation.VALID_OPS[1] = 2;
        KVOperation.VALID_OPS[2] = 3;
        KVOperation.VALID_OPS[3] = 4;
        KVOperation.VALID_OPS[4] = 5;
        KVOperation.VALID_OPS[5] = 6;
        KVOperation.VALID_OPS[6] = 7;
        KVOperation.VALID_OPS[7] = 8;
        KVOperation.VALID_OPS[8] = 9;
        KVOperation.VALID_OPS[9] = 10;
        KVOperation.VALID_OPS[10] = 11;
        KVOperation.VALID_OPS[11] = 12;
        KVOperation.VALID_OPS[12] = 13;
        KVOperation.VALID_OPS[13] = 14;
        KVOperation.VALID_OPS[14] = 15;
        KVOperation.VALID_OPS[15] = 16;
        KVOperation.VALID_OPS[16] = 17;
        KVOperation.VALID_OPS[17] = 18;
        KVOperation.VALID_OPS[18] = 19;
    }
}

