/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.storage.BaseRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVState;
import com.alipay.sofa.jraft.rhea.storage.KVStateOutputList;
import com.alipay.sofa.jraft.rhea.util.Pair;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;

public abstract class BatchRawKVStore<T>
extends BaseRawKVStore<T> {
    public void batchPut(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.put(op.getKey(), op.getValue(), kvState.getDone());
        }
    }

    public void batchPutIfAbsent(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.putIfAbsent(op.getKey(), op.getValue(), kvState.getDone());
        }
    }

    public void batchPutList(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.put(kvState.getOp().getEntries(), kvState.getDone());
        }
    }

    public void batchDelete(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.delete(kvState.getOp().getKey(), kvState.getDone());
        }
    }

    public void batchDeleteRange(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.deleteRange(op.getStartKey(), op.getEndKey(), kvState.getDone());
        }
    }

    public void batchDeleteList(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.delete(kvState.getOp().getKeys(), kvState.getDone());
        }
    }

    public void batchGetSequence(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.getSequence(op.getSeqKey(), op.getStep(), kvState.getDone());
        }
    }

    public void batchNodeExecute(KVStateOutputList kvStates, boolean isLeader) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.execute(kvState.getOp().getNodeExecutor(), isLeader, kvState.getDone());
        }
    }

    public void batchTryLockWith(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            Pair<Boolean, DistributedLock.Acquirer> acquirerPair = op.getAcquirerPair();
            this.tryLockWith(op.getKey(), op.getFencingKey(), acquirerPair.getKey(), acquirerPair.getValue(), kvState.getDone());
        }
    }

    public void batchReleaseLockWith(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.releaseLockWith(op.getKey(), op.getAcquirer(), kvState.getDone());
        }
    }

    public void batchGet(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.get(kvState.getOp().getKey(), kvState.getDone());
        }
    }

    public void batchMultiGet(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.multiGet(kvState.getOp().getKeyList(), kvState.getDone());
        }
    }

    public void batchContainsKey(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.containsKey(kvState.getOp().getKey(), kvState.getDone());
        }
    }

    public void batchScan(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.scan(op.getStartKey(), op.getEndKey(), op.getLimit(), true, op.isReturnValue(), kvState.getDone());
        }
    }

    public void batchGetAndPut(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.getAndPut(op.getKey(), op.getValue(), kvState.getDone());
        }
    }

    public void batchCompareAndPut(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.compareAndPut(op.getKey(), op.getExpect(), op.getValue(), kvState.getDone());
        }
    }

    public void batchMerge(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            KVOperation op = kvState.getOp();
            this.merge(op.getKey(), op.getValue(), kvState.getDone());
        }
    }

    public void batchResetSequence(KVStateOutputList kvStates) {
        int l = kvStates.size();
        for (int i = 0; i < l; ++i) {
            KVState kvState = (KVState)kvStates.get(i);
            this.resetSequence(kvState.getOp().getKey(), kvState.getDone());
        }
    }
}

