/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.StorageException;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.NodeExecutor;
import com.alipay.sofa.jraft.rhea.storage.RawKVStore;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.codahale.metrics.Timer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRawKVStore<T>
implements RawKVStore,
Lifecycle<T> {
    @Override
    public void get(byte[] key, KVStoreClosure closure) {
        this.get(key, true, closure);
    }

    @Override
    public void multiGet(List<byte[]> keys, KVStoreClosure closure) {
        this.multiGet(keys, true, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, returnValue, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, true, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, readOnlySafe, true, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(NodeExecutor nodeExecutor, boolean isLeader, KVStoreClosure closure) {
        Timer.Context timeCtx = BaseRawKVStore.getTimeContext("EXECUTE");
        try {
            if (nodeExecutor != null) {
                nodeExecutor.execute(Status.OK(), isLeader);
            }
            BaseRawKVStore.setSuccess(closure, Boolean.TRUE);
        }
        catch (Exception e) {
            Logger LOG = LoggerFactory.getLogger(this.getClass());
            LOG.error("Fail to [EXECUTE], {}.", (Object)StackTraceUtil.stackTrace(e));
            if (nodeExecutor != null) {
                nodeExecutor.execute(new Status(RaftError.EIO, "Fail to [EXECUTE]", new Object[0]), isLeader);
            }
            BaseRawKVStore.setCriticalError(closure, "Fail to [EXECUTE]", (Throwable)e);
        }
        finally {
            timeCtx.stop();
        }
    }

    public long getSafeEndValueForSequence(long startVal, int step) {
        return Math.max(startVal, Long.MAX_VALUE - (long)step < startVal ? Long.MAX_VALUE : startVal + (long)step);
    }

    public abstract long getApproximateKeysInRange(byte[] var1, byte[] var2);

    public abstract byte[] jumpOver(byte[] var1, long var2);

    public abstract void initFencingToken(byte[] var1, byte[] var2);

    static Timer.Context getTimeContext(String opName) {
        return KVMetrics.timer("rhea-db-timer", opName).time();
    }

    static void setSuccess(KVStoreClosure closure, Object data) {
        if (closure != null) {
            closure.setData(data);
            closure.run(Status.OK());
        }
    }

    static void setFailure(KVStoreClosure closure, String message) {
        if (closure != null) {
            closure.setError(Errors.STORAGE_ERROR);
            closure.run(new Status(RaftError.EIO, message, new Object[0]));
        }
    }

    static void setCriticalError(KVStoreClosure closure, String message, Throwable error) {
        BaseRawKVStore.setClosureError(closure);
        if (error != null) {
            throw new StorageException(message, error);
        }
    }

    static void setCriticalError(List<KVStoreClosure> closures, String message, Throwable error) {
        for (KVStoreClosure closure : closures) {
            BaseRawKVStore.setClosureError(closure);
        }
        if (error != null) {
            throw new StorageException(message, error);
        }
    }

    static void setClosureError(KVStoreClosure closure) {
        if (closure != null) {
            closure.setError(Errors.STORAGE_ERROR);
        }
    }

    static void setData(KVStoreClosure closure, Object data) {
        if (closure != null) {
            closure.setData(data);
        }
    }

    static Object getData(KVStoreClosure closure) {
        return closure == null ? null : closure.getData();
    }
}

