/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.serialization.Serializer;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.KVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.ZipUtil;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.CRC64;
import com.alipay.sofa.jraft.util.Requires;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKVStoreSnapshotFile
implements KVStoreSnapshotFile {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKVStoreSnapshotFile.class);
    private static final String SNAPSHOT_DIR = "kv";
    private static final String SNAPSHOT_ARCHIVE = "kv.zip";
    protected final Serializer serializer = Serializers.getDefault();

    @Override
    public void save(SnapshotWriter writer, Region region, Closure done, ExecutorService executor) {
        String writerPath = writer.getPath();
        String snapshotPath = Paths.get(writerPath, SNAPSHOT_DIR).toString();
        try {
            this.doSnapshotSave(snapshotPath, region, executor).whenComplete((metaBuilder, throwable) -> {
                if (throwable == null) {
                    executor.execute(() -> this.compressSnapshot(writer, (LocalFileMetaOutter.LocalFileMeta.Builder)metaBuilder, done));
                } else {
                    LOG.error("Fail to save snapshot, path={}, file list={}, {}.", new Object[]{writerPath, writer.listFiles(), StackTraceUtil.stackTrace(throwable)});
                    done.run(new Status(RaftError.EIO, "Fail to save snapshot at %s, error is %s", new Object[]{writerPath, throwable.getMessage()}));
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Fail to save snapshot, path={}, file list={}, {}.", new Object[]{writerPath, writer.listFiles(), StackTraceUtil.stackTrace(t)});
            done.run(new Status(RaftError.EIO, "Fail to save snapshot at %s, error is %s", new Object[]{writerPath, t.getMessage()}));
        }
    }

    @Override
    public boolean load(SnapshotReader reader, Region region) {
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)reader.getFileMeta(SNAPSHOT_ARCHIVE);
        String readerPath = reader.getPath();
        if (meta == null) {
            LOG.error("Can't find kv snapshot file, path={}.", (Object)readerPath);
            return false;
        }
        String snapshotPath = Paths.get(readerPath, SNAPSHOT_DIR).toString();
        try {
            this.decompressSnapshot(readerPath, meta);
            this.doSnapshotLoad(snapshotPath, meta, region);
            File tmp = new File(snapshotPath);
            if (tmp.exists()) {
                FileUtils.forceDelete((File)new File(snapshotPath));
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("Fail to load snapshot, path={}, file list={}, {}.", new Object[]{readerPath, reader.listFiles(), StackTraceUtil.stackTrace(t)});
            return false;
        }
    }

    abstract CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder> doSnapshotSave(String var1, Region var2, ExecutorService var3) throws Exception;

    abstract void doSnapshotLoad(String var1, LocalFileMetaOutter.LocalFileMeta var2, Region var3) throws Exception;

    protected void compressSnapshot(SnapshotWriter writer, LocalFileMetaOutter.LocalFileMeta.Builder metaBuilder, Closure done) {
        String writerPath = writer.getPath();
        String outputFile = Paths.get(writerPath, SNAPSHOT_ARCHIVE).toString();
        try {
            CRC64 checksum = new CRC64();
            ZipUtil.compress(writerPath, SNAPSHOT_DIR, outputFile, (Checksum)checksum);
            metaBuilder.setChecksum(Long.toHexString(checksum.getValue()));
            if (writer.addFile(SNAPSHOT_ARCHIVE, (Message)metaBuilder.build())) {
                done.run(Status.OK());
            } else {
                done.run(new Status(RaftError.EIO, "Fail to add snapshot file: %s", new Object[]{writerPath}));
            }
        }
        catch (Throwable t) {
            LOG.error("Fail to compress snapshot, path={}, file list={}, {}.", new Object[]{writerPath, writer.listFiles(), StackTraceUtil.stackTrace(t)});
            done.run(new Status(RaftError.EIO, "Fail to compress snapshot at %s, error is %s", new Object[]{writerPath, t.getMessage()}));
        }
    }

    protected void decompressSnapshot(String readerPath, LocalFileMetaOutter.LocalFileMeta meta) throws IOException {
        String sourceFile = Paths.get(readerPath, SNAPSHOT_ARCHIVE).toString();
        CRC64 checksum = new CRC64();
        ZipUtil.decompress(sourceFile, readerPath, (Checksum)checksum);
        if (meta.hasChecksum()) {
            Requires.requireTrue((boolean)meta.getChecksum().equals(Long.toHexString(checksum.getValue())), (Object)"Snapshot checksum failed");
        }
    }

    protected <T> T readMetadata(LocalFileMetaOutter.LocalFileMeta meta, Class<T> cls) {
        ByteString userMeta = meta.getUserMeta();
        return this.serializer.readObject(userMeta.toByteArray(), cls);
    }

    protected <T> LocalFileMetaOutter.LocalFileMeta.Builder writeMetadata(T metadata) {
        if (metadata == null) {
            return LocalFileMetaOutter.LocalFileMeta.newBuilder();
        }
        return LocalFileMetaOutter.LocalFileMeta.newBuilder().setUserMeta(ByteString.copyFrom((byte[])this.serializer.writeObject(metadata)));
    }
}

