/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io;

import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.NioBufOutput;
import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.ProtocolException;
import com.alipay.sofa.jraft.rhea.serialization.io.OutputBuf;
import com.alipay.sofa.jraft.rhea.util.VarInts;
import com.alipay.sofa.jraft.rhea.util.internal.UnsafeDirectBufferUtil;
import com.alipay.sofa.jraft.util.internal.UnsafeUtf8Util;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

class UnsafeNioBufOutput
extends NioBufOutput {
    private long memoryAddress;

    UnsafeNioBufOutput(OutputBuf outputBuf, int minWritableBytes, int maxCapacity) {
        super(outputBuf, minWritableBytes, maxCapacity);
        this.updateBufferAddress();
    }

    @Override
    public void writeString(int fieldNumber, CharSequence value, boolean repeated) throws IOException {
        this.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)2));
        int minLength = value.length();
        int maxLength = minLength * 3;
        int minLengthVarIntSize = VarInts.computeRawVarInt32Size(minLength);
        int maxLengthVarIntSize = VarInts.computeRawVarInt32Size(maxLength);
        if (minLengthVarIntSize == maxLengthVarIntSize) {
            int position = this.nioBuffer.position();
            this.ensureCapacity(maxLengthVarIntSize + maxLength);
            int stringStartPos = position + maxLengthVarIntSize;
            this.nioBuffer.position(stringStartPos);
            UnsafeUtf8Util.encodeUtf8Direct((CharSequence)value, (ByteBuffer)this.nioBuffer);
            int length = this.nioBuffer.position() - stringStartPos;
            this.nioBuffer.position(position);
            this.writeVarInt32(length);
            this.nioBuffer.position(stringStartPos + length);
        } else {
            int length = UnsafeUtf8Util.encodedLength((CharSequence)value);
            this.writeVarInt32(length);
            this.ensureCapacity(length);
            UnsafeUtf8Util.encodeUtf8Direct((CharSequence)value, (ByteBuffer)this.nioBuffer);
        }
    }

    @Override
    protected void writeVarInt32(int value) throws IOException {
        this.ensureCapacity(5);
        int position = this.nioBuffer.position();
        if ((value & 0xFFFFFF80) == 0) {
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)value);
        } else if ((value & 0xFFFFC000) == 0) {
            UnsafeDirectBufferUtil.setShort(this.address(position), (value & 0x7F | 0x80) << 8 | value >>> 7);
            position += 2;
        } else if ((value & 0xFFE00000) == 0) {
            UnsafeDirectBufferUtil.setShort(this.address(position), (value & 0x7F | 0x80) << 8 | (value >>> 7 & 0x7F | 0x80));
            position += 2;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 14));
        } else if ((value & 0xF0000000) == 0) {
            UnsafeDirectBufferUtil.setInt(this.address(position), (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
            position += 4;
        } else {
            UnsafeDirectBufferUtil.setInt(this.address(position), (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
            position += 4;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 28));
        }
        this.nioBuffer.position(position);
    }

    @Override
    protected void writeVarInt64(long value) throws IOException {
        this.ensureCapacity(10);
        int position = this.nioBuffer.position();
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)value);
        } else if (value < 0L) {
            UnsafeDirectBufferUtil.setLong(this.address(position), (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | (value >>> 49 & 0x7FL | 0x80L));
            UnsafeDirectBufferUtil.setShort(this.address(position += 8), ((int)(value >>> 56) & 0x7F | 0x80) << 8 | (int)(value >>> 63));
            position += 2;
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            UnsafeDirectBufferUtil.setShort(this.address(position), ((int)value & 0x7F | 0x80) << 8 | (byte)(value >>> 7));
            position += 2;
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            UnsafeDirectBufferUtil.setShort(this.address(position), ((int)value & 0x7F | 0x80) << 8 | ((int)value >>> 7 & 0x7F | 0x80));
            position += 2;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 14));
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            UnsafeDirectBufferUtil.setInt(this.address(position), ((int)value & 0x7F | 0x80) << 24 | ((int)value >>> 7 & 0x7F | 0x80) << 16 | ((int)value >>> 14 & 0x7F | 0x80) << 8 | (int)(value >>> 21));
            position += 4;
        } else if ((value & 0xFFFFFFF800000000L) == 0L) {
            UnsafeDirectBufferUtil.setInt(this.address(position), ((int)value & 0x7F | 0x80) << 24 | ((int)value >>> 7 & 0x7F | 0x80) << 16 | ((int)value >>> 14 & 0x7F | 0x80) << 8 | ((int)value >>> 21 & 0x7F | 0x80));
            position += 4;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 28));
        } else if ((value & 0xFFFFFC0000000000L) == 0L) {
            UnsafeDirectBufferUtil.setInt(this.address(position), ((int)value & 0x7F | 0x80) << 24 | ((int)value >>> 7 & 0x7F | 0x80) << 16 | ((int)value >>> 14 & 0x7F | 0x80) << 8 | ((int)value >>> 21 & 0x7F | 0x80));
            UnsafeDirectBufferUtil.setShort(this.address(position += 4), ((int)(value >>> 28) & 0x7F | 0x80) << 8 | (int)(value >>> 35));
            position += 2;
        } else if ((value & 0xFFFE000000000000L) == 0L) {
            UnsafeDirectBufferUtil.setInt(this.address(position), ((int)value & 0x7F | 0x80) << 24 | ((int)value >>> 7 & 0x7F | 0x80) << 16 | ((int)value >>> 14 & 0x7F | 0x80) << 8 | ((int)value >>> 21 & 0x7F | 0x80));
            UnsafeDirectBufferUtil.setShort(this.address(position += 4), ((int)(value >>> 28) & 0x7F | 0x80) << 8 | ((int)(value >>> 35) & 0x7F | 0x80));
            position += 2;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 42));
        } else if ((value & 0xFF00000000000000L) == 0L) {
            UnsafeDirectBufferUtil.setLong(this.address(position), (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49);
            position += 8;
        } else {
            UnsafeDirectBufferUtil.setLong(this.address(position), (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | (value >>> 49 & 0x7FL | 0x80L));
            position += 8;
            UnsafeDirectBufferUtil.setByte(this.address(position++), (byte)(value >>> 56));
        }
        this.nioBuffer.position(position);
    }

    @Override
    protected void writeInt32LE(int value) throws IOException {
        this.ensureCapacity(4);
        int position = this.nioBuffer.position();
        UnsafeDirectBufferUtil.setIntLE(this.address(position), value);
        this.nioBuffer.position(position + 4);
    }

    @Override
    protected void writeInt64LE(long value) throws IOException {
        this.ensureCapacity(8);
        int position = this.nioBuffer.position();
        UnsafeDirectBufferUtil.setLongLE(this.address(position), value);
        this.nioBuffer.position(position + 8);
    }

    @Override
    protected void writeByte(byte value) throws IOException {
        this.ensureCapacity(1);
        int position = this.nioBuffer.position();
        UnsafeDirectBufferUtil.setByte(this.address(position), value);
        this.nioBuffer.position(position + 1);
    }

    @Override
    protected void writeByteArray(byte[] value, int offset, int length) throws IOException {
        this.ensureCapacity(length);
        int position = this.nioBuffer.position();
        UnsafeDirectBufferUtil.setBytes(this.address(position), value, offset, length);
        this.nioBuffer.position(position + length);
    }

    @Override
    protected void ensureCapacity(int required) throws ProtocolException {
        if (this.nioBuffer.remaining() < required) {
            int position = this.nioBuffer.position();
            while (this.capacity - position < required) {
                if (this.capacity == this.maxCapacity) {
                    throw new ProtocolException("Buffer overflow. Available: " + (this.capacity - position) + ", required: " + required);
                }
                this.capacity = Math.min(this.capacity << 1, this.maxCapacity);
                if (this.capacity >= 0) continue;
                this.capacity = this.maxCapacity;
            }
            this.nioBuffer = this.outputBuf.nioByteBuffer(this.capacity - position);
            this.capacity = this.nioBuffer.limit();
            this.updateBufferAddress();
        }
    }

    private void updateBufferAddress() {
        this.memoryAddress = UnsafeUtil.addressOffset((ByteBuffer)this.nioBuffer);
    }

    private long address(int position) {
        return this.memoryAddress + (long)position;
    }
}

