/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io;

import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.ProtocolException;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.rhea.util.internal.UnsafeDirectBufferUtil;
import com.alipay.sofa.jraft.util.internal.UnsafeUtf8Util;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import io.protostuff.ByteBufferInput;
import io.protostuff.ByteString;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.ProtobufException;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

class UnsafeNioBufInput
implements Input {
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final Method byteStringWrapMethod;
    private final ByteBuffer nioBuffer;
    private int lastTag = 0;
    private int packedLimit = 0;
    private long memoryAddress;
    public final boolean decodeNestedMessageAsGroup;

    UnsafeNioBufInput(ByteBuffer nioBuffer, boolean protostuffMessage) {
        this.nioBuffer = nioBuffer;
        this.decodeNestedMessageAsGroup = protostuffMessage;
        this.updateBufferAddress();
    }

    public int currentOffset() {
        return this.nioBuffer.position();
    }

    public int currentLimit() {
        return this.nioBuffer.limit();
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.nioBuffer.position();
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public int readTag() throws IOException {
        if (!this.nioBuffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarInt32();
        if (tag >>> 3 == 0) {
            throw ProtocolException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtocolException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType((int)tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                int size = this.readRawVarInt32();
                if (size < 0) {
                    throw ProtocolException.negativeSize();
                }
                this.nioBuffer.position(this.nioBuffer.position() + size);
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag((int)WireFormat.getTagFieldNumber((int)tag), (int)4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtocolException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.skipField(this.lastTag);
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (!this.nioBuffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.nioBuffer.position()) {
                throw ProtocolException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int tag = this.readRawVarInt32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (tag & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtocolException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (tag & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    private void checkIfPackedField() throws IOException {
        if (this.packedLimit == 0 && WireFormat.getTagWireType((int)this.lastTag) == 2) {
            int length = this.readRawVarInt32();
            if (length < 0) {
                throw ProtocolException.negativeSize();
            }
            if (this.nioBuffer.position() + length > this.nioBuffer.limit()) {
                throw ProtocolException.misreportedSize();
            }
            this.packedLimit = this.nioBuffer.position() + length;
        }
    }

    public double readDouble() throws IOException {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt64();
    }

    public long readInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt64();
    }

    public int readInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public long readFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        this.checkIfPackedField();
        int position = this.nioBuffer.position();
        boolean result = UnsafeDirectBufferUtil.getByte(this.address(position)) != 0;
        this.nioBuffer.position(position + 1);
        return result;
    }

    public int readUInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public int readEnum() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public int readSFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        this.checkIfPackedField();
        int n = this.readRawVarInt32();
        return n >>> 1 ^ -(n & 1);
    }

    public long readSInt64() throws IOException {
        this.checkIfPackedField();
        long n = this.readRawVarInt64();
        return n >>> 1 ^ -(n & 1L);
    }

    public String readString() throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        int position = this.nioBuffer.position();
        String result = UnsafeUtf8Util.decodeUtf8Direct((ByteBuffer)this.nioBuffer, (int)position, (int)length);
        this.nioBuffer.position(position + length);
        return result;
    }

    public ByteString readBytes() throws IOException {
        try {
            return (ByteString)byteStringWrapMethod.invoke(null, new Object[]{this.readByteArray()});
        }
        catch (Exception e) {
            ThrowUtil.throwException(e);
            return null;
        }
    }

    public void readBytes(ByteBuffer bb) throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        bb.put(this.nioBuffer);
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        byte[] copy = new byte[length];
        int position = this.nioBuffer.position();
        UnsafeDirectBufferUtil.getBytes(this.address(position), copy, 0, length);
        this.nioBuffer.position(position + length);
        return copy;
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(value, schema);
        }
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        ByteBuffer dup = this.nioBuffer.slice();
        dup.limit(length);
        if (value == null) {
            value = schema.newMessage();
        }
        ByteBufferInput nestedInput = new ByteBufferInput(dup, false);
        schema.mergeFrom((Input)nestedInput, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        nestedInput.checkLastTagWas(0);
        this.nioBuffer.position(this.nioBuffer.position() + length);
        return value;
    }

    private <T> T mergeObjectEncodedAsGroup(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        return value;
    }

    public int readRawVarInt32() throws IOException {
        byte tmp;
        int position = this.nioBuffer.position();
        if ((tmp = UnsafeDirectBufferUtil.getByte(this.address(position++))) >= 0) {
            this.nioBuffer.position(position);
            return tmp;
        }
        int result = tmp & 0x7F;
        if ((tmp = UnsafeDirectBufferUtil.getByte(this.address(position++))) >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if ((tmp = UnsafeDirectBufferUtil.getByte(this.address(position++))) >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if ((tmp = UnsafeDirectBufferUtil.getByte(this.address(position++))) >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = UnsafeDirectBufferUtil.getByte(this.address(position++));
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (UnsafeDirectBufferUtil.getByte(this.address(position++)) < 0) continue;
                            this.nioBuffer.position(position);
                            return result;
                        }
                        throw ProtocolException.malformedVarInt();
                    }
                }
            }
        }
        this.nioBuffer.position(position);
        return result;
    }

    public long readRawVarInt64() throws IOException {
        long result = 0L;
        int position = this.nioBuffer.position();
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = UnsafeDirectBufferUtil.getByte(this.address(position++));
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.nioBuffer.position(position);
            return result;
        }
        throw ProtocolException.malformedVarInt();
    }

    public int readRawLittleEndian32() throws IOException {
        int position = this.nioBuffer.position();
        int result = UnsafeDirectBufferUtil.getIntLE(this.address(position));
        this.nioBuffer.position(position + 4);
        return result;
    }

    public long readRawLittleEndian64() throws IOException {
        int position = this.nioBuffer.position();
        long result = UnsafeDirectBufferUtil.getLongLE(this.address(position));
        this.nioBuffer.position(position + 8);
        return result;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (utf8String) {
            if (this.nioBuffer.hasArray()) {
                output.writeByteRange(true, fieldNumber, this.nioBuffer.array(), this.nioBuffer.arrayOffset() + this.nioBuffer.position(), length, repeated);
                this.nioBuffer.position(this.nioBuffer.position() + length);
            } else {
                byte[] bytes = new byte[length];
                int position = this.nioBuffer.position();
                UnsafeDirectBufferUtil.getBytes(this.address(position), bytes, 0, length);
                this.nioBuffer.position(position + length);
                output.writeByteRange(true, fieldNumber, bytes, 0, bytes.length, repeated);
            }
        } else {
            if (this.nioBuffer.remaining() < length) {
                throw ProtocolException.misreportedSize();
            }
            ByteBuffer dup = this.nioBuffer.slice();
            dup.limit(length);
            output.writeBytes(fieldNumber, dup, repeated);
            this.nioBuffer.position(this.nioBuffer.position() + length);
        }
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    private long address(int position) {
        return this.memoryAddress + (long)position;
    }

    private void updateBufferAddress() {
        this.memoryAddress = UnsafeUtil.addressOffset((ByteBuffer)this.nioBuffer);
    }

    static {
        try {
            byteStringWrapMethod = ByteString.class.getDeclaredMethod("wrap", byte[].class);
            byteStringWrapMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }
}

