/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.serialization.impl.protostuff;

import com.alipay.sofa.jraft.rhea.serialization.Serializer;
import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.Inputs;
import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.LinkedBuffers;
import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.Outputs;
import com.alipay.sofa.jraft.rhea.serialization.io.InputBuf;
import com.alipay.sofa.jraft.rhea.serialization.io.OutputBuf;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import io.protostuff.Input;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ProtoStuffSerializer
extends Serializer {
    @Override
    public <T> OutputBuf writeObject(OutputBuf outputBuf, T obj) {
        Schema schema = RuntimeSchema.getSchema(obj.getClass());
        Output output = Outputs.getOutput(outputBuf);
        try {
            schema.writeTo(output, obj);
        }
        catch (IOException e) {
            ThrowUtil.throwException(e);
        }
        return outputBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] writeObject(T obj) {
        Schema schema = RuntimeSchema.getSchema(obj.getClass());
        LinkedBuffer buf = LinkedBuffers.getLinkedBuffer();
        Output output = Outputs.getOutput(buf);
        try {
            schema.writeTo(output, obj);
            byte[] byArray = Outputs.toByteArray(output);
            return byArray;
        }
        catch (IOException e) {
            ThrowUtil.throwException(e);
        }
        finally {
            LinkedBuffers.resetBuf(buf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readObject(InputBuf inputBuf, Class<T> clazz) {
        Schema schema = RuntimeSchema.getSchema(clazz);
        Object msg = schema.newMessage();
        Input input = Inputs.getInput(inputBuf);
        try {
            schema.mergeFrom(input, msg);
            Inputs.checkLastTagWas(input, 0);
        }
        catch (IOException e) {
            ThrowUtil.throwException(e);
        }
        finally {
            inputBuf.release();
        }
        return (T)msg;
    }

    @Override
    public <T> T readObject(ByteBuffer buf, Class<T> clazz) {
        Schema schema = RuntimeSchema.getSchema(clazz);
        Object msg = schema.newMessage();
        Input input = Inputs.getInput(buf);
        try {
            schema.mergeFrom(input, msg);
            Inputs.checkLastTagWas(input, 0);
        }
        catch (IOException e) {
            ThrowUtil.throwException(e);
        }
        return (T)msg;
    }

    @Override
    public <T> T readObject(byte[] bytes, int offset, int length, Class<T> clazz) {
        Schema schema = RuntimeSchema.getSchema(clazz);
        Object msg = schema.newMessage();
        Input input = Inputs.getInput(bytes, offset, length);
        try {
            schema.mergeFrom(input, msg);
            Inputs.checkLastTagWas(input, 0);
        }
        catch (IOException e) {
            ThrowUtil.throwException(e);
        }
        return (T)msg;
    }

    public String toString() {
        return "proto_stuff";
    }

    static {
        String always_use_sun_reflection_factory = SystemPropertyUtil.get((String)"rhea.serializer.protostuff.always_use_sun_reflection_factory", (String)"false");
        SystemPropertyUtil.setProperty((String)"protostuff.runtime.always_use_sun_reflection_factory", (String)always_use_sun_reflection_factory);
        String allow_null_array_element = SystemPropertyUtil.get((String)"rhea.serializer.protostuff.allow_null_array_element", (String)"false");
        SystemPropertyUtil.setProperty((String)"protostuff.runtime.allow_null_array_element", (String)allow_null_array_element);
    }
}

