/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.rocks.support;

import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.rhea.util.internal.ReferenceFieldUpdater;
import com.alipay.sofa.jraft.rhea.util.internal.Updaters;
import com.alipay.sofa.jraft.util.DebugStatistics;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;

public final class RocksStatistics {
    private static final ReferenceFieldUpdater<RocksRawKVStore, DebugStatistics> statisticsGetter = Updaters.newReferenceFieldUpdater(RocksRawKVStore.class, "statistics");
    private static final ReferenceFieldUpdater<RocksRawKVStore, RocksDB> dbGetter = Updaters.newReferenceFieldUpdater(RocksRawKVStore.class, "db");

    public static long getTickerCount(RocksRawKVStore rocksRawKVStore, TickerType tickerType) {
        Statistics statistics = RocksStatistics.statistics(rocksRawKVStore);
        if (statistics == null) {
            return -1L;
        }
        return statistics.getTickerCount(tickerType);
    }

    public static long getAndResetTickerCount(RocksRawKVStore rocksRawKVStore, TickerType tickerType) {
        Statistics statistics = RocksStatistics.statistics(rocksRawKVStore);
        if (statistics == null) {
            return -1L;
        }
        return statistics.getAndResetTickerCount(tickerType);
    }

    public static HistogramData getHistogramData(RocksRawKVStore rocksRawKVStore, HistogramType histogramType) {
        Statistics statistics = RocksStatistics.statistics(rocksRawKVStore);
        if (statistics == null) {
            return null;
        }
        return statistics.getHistogramData(histogramType);
    }

    public String getHistogramString(RocksRawKVStore rocksRawKVStore, HistogramType histogramType) {
        Statistics statistics = RocksStatistics.statistics(rocksRawKVStore);
        if (statistics == null) {
            return "";
        }
        return statistics.getHistogramString(histogramType);
    }

    public static String getStatisticsString(RocksRawKVStore rocksRawKVStore) {
        Statistics statistics = RocksStatistics.statistics(rocksRawKVStore);
        if (statistics == null) {
            return "";
        }
        return statistics.toString();
    }

    public static String getProperty(RocksRawKVStore rocksRawKVStore, String name) {
        RocksDB db = RocksStatistics.db(rocksRawKVStore);
        if (db != null) {
            try {
                return db.getProperty(name);
            }
            catch (RocksDBException e) {
                ThrowUtil.throwException(e);
            }
        }
        throw new NullPointerException("db");
    }

    private static Statistics statistics(RocksRawKVStore rocksRawKVStore) {
        return (Statistics)statisticsGetter.get(rocksRawKVStore);
    }

    private static RocksDB db(RocksRawKVStore rocksRawKVStore) {
        return dbGetter.get(rocksRawKVStore);
    }

    private RocksStatistics() {
    }
}

