/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.RegionEngine;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.metadata.Instruction;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.storage.BaseKVStoreClosure;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.util.Endpoint;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionProcessor.class);
    private final StoreEngine storeEngine;

    public InstructionProcessor(StoreEngine storeEngine) {
        this.storeEngine = storeEngine;
    }

    public void process(List<Instruction> instructions) {
        LOG.info("Received instructions: {}.", instructions);
        for (Instruction instruction : instructions) {
            if (!this.checkInstruction(instruction)) continue;
            this.processSplit(instruction);
            this.processTransferLeader(instruction);
        }
    }

    private boolean processSplit(Instruction instruction) {
        try {
            Instruction.RangeSplit rangeSplit = instruction.getRangeSplit();
            if (rangeSplit == null) {
                return false;
            }
            Long newRegionId = rangeSplit.getNewRegionId();
            if (newRegionId == null) {
                LOG.error("RangeSplit#newRegionId must not be null, {}.", (Object)instruction);
                return false;
            }
            Region region = instruction.getRegion();
            long regionId = region.getId();
            RegionEngine engine = this.storeEngine.getRegionEngine(regionId);
            if (engine == null) {
                LOG.error("Could not found regionEngine, {}.", (Object)instruction);
                return false;
            }
            if (!region.equals(engine.getRegion())) {
                LOG.warn("Instruction [{}] is out of date.", (Object)instruction);
                return false;
            }
            final CompletableFuture future = new CompletableFuture();
            this.storeEngine.applySplit(regionId, newRegionId, new BaseKVStoreClosure(){

                public void run(Status status) {
                    future.complete(status);
                }
            });
            Status status = (Status)future.get(20L, TimeUnit.SECONDS);
            boolean ret = status.isOk();
            if (ret) {
                LOG.info("Range-split succeeded, instruction: {}.", (Object)instruction);
            } else {
                LOG.warn("Range-split failed: {}, instruction: {}.", (Object)status, (Object)instruction);
            }
            return ret;
        }
        catch (Throwable t) {
            LOG.error("Caught an exception on #processSplit: {}.", (Object)StackTraceUtil.stackTrace(t));
            return false;
        }
    }

    private boolean processTransferLeader(Instruction instruction) {
        try {
            Instruction.TransferLeader transferLeader = instruction.getTransferLeader();
            if (transferLeader == null) {
                return false;
            }
            Endpoint toEndpoint = transferLeader.getMoveToEndpoint();
            if (toEndpoint == null) {
                LOG.error("TransferLeader#toEndpoint must not be null, {}.", (Object)instruction);
                return false;
            }
            Region region = instruction.getRegion();
            long regionId = region.getId();
            RegionEngine engine = this.storeEngine.getRegionEngine(regionId);
            if (engine == null) {
                LOG.error("Could not found regionEngine, {}.", (Object)instruction);
                return false;
            }
            if (!region.equals(engine.getRegion())) {
                LOG.warn("Instruction [{}] is out of date.", (Object)instruction);
                return false;
            }
            return engine.transferLeadershipTo(toEndpoint);
        }
        catch (Throwable t) {
            LOG.error("Caught an exception on #processTransferLeader: {}.", (Object)StackTraceUtil.stackTrace(t));
            return false;
        }
    }

    private boolean checkInstruction(Instruction instruction) {
        if (instruction == null) {
            LOG.warn("Null instructions element.");
            return false;
        }
        if (instruction.getRegion() == null) {
            LOG.warn("Null region with instruction: {}.", (Object)instruction);
            return false;
        }
        return true;
    }
}

