/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.client.failover.FailoverClosure;
import com.alipay.sofa.jraft.rhea.client.pd.AbstractPlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverRpcService;
import com.alipay.sofa.jraft.rhea.cmd.pd.BaseRequest;
import com.alipay.sofa.jraft.rhea.cmd.pd.BaseResponse;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.ErrorsHelper;
import com.alipay.sofa.jraft.rhea.options.RpcOptions;
import com.alipay.sofa.jraft.rhea.rpc.ExtSerializerSupports;
import com.alipay.sofa.jraft.rhea.util.concurrent.CallerRunsPolicyWithReport;
import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlacementDriverRpcService
implements PlacementDriverRpcService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPlacementDriverRpcService.class);
    private final PlacementDriverClient pdClient;
    private final RpcClient rpcClient;
    private ThreadPoolExecutor rpcCallbackExecutor;
    private int rpcTimeoutMillis;
    private boolean started;

    public DefaultPlacementDriverRpcService(PlacementDriverClient pdClient) {
        this.pdClient = pdClient;
        this.rpcClient = ((AbstractPlacementDriverClient)pdClient).getRpcClient();
    }

    public synchronized boolean init(RpcOptions opts) {
        if (this.started) {
            LOG.info("[DefaultPlacementDriverRpcService] already started.");
            return true;
        }
        this.rpcCallbackExecutor = this.createRpcCallbackExecutor(opts);
        this.rpcTimeoutMillis = opts.getRpcTimeoutMillis();
        Requires.requireTrue((this.rpcTimeoutMillis > 0 ? 1 : 0) != 0, (Object)"opts.rpcTimeoutMillis must > 0");
        LOG.info("[DefaultPlacementDriverRpcService] start successfully, options: {}.", (Object)opts);
        this.started = true;
        return true;
    }

    public synchronized void shutdown() {
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.rpcCallbackExecutor);
        this.started = false;
        LOG.info("[DefaultPlacementDriverRpcService] shutdown successfully.");
    }

    @Override
    public <V> CompletableFuture<V> callPdServerWithRpc(BaseRequest request, FailoverClosure<V> closure, Errors lastCause) {
        boolean forceRefresh = ErrorsHelper.isInvalidPeer(lastCause);
        Endpoint endpoint = this.pdClient.getPdLeader(forceRefresh, this.rpcTimeoutMillis);
        this.internalCallPdWithRpc(endpoint, request, closure);
        return closure.future();
    }

    private <V> void internalCallPdWithRpc(Endpoint endpoint, BaseRequest request, final FailoverClosure<V> closure) {
        final String address = endpoint.toString();
        InvokeContext invokeCtx = ExtSerializerSupports.getInvokeContext();
        InvokeCallback invokeCallback = new InvokeCallback(){

            public void onResponse(Object result) {
                BaseResponse response = (BaseResponse)result;
                if (response.isSuccess()) {
                    closure.setData(response.getValue());
                    closure.run(Status.OK());
                } else {
                    closure.setError(response.getError());
                    closure.run(new Status(-1, "RPC failed with address: %s, response: %s", new Object[]{address, response}));
                }
            }

            public void onException(Throwable t) {
                closure.failure(t);
            }

            public Executor getExecutor() {
                return DefaultPlacementDriverRpcService.this.rpcCallbackExecutor;
            }
        };
        try {
            this.rpcClient.invokeWithCallback(address, (Object)request, invokeCtx, invokeCallback, this.rpcTimeoutMillis);
        }
        catch (Throwable t) {
            closure.failure(t);
        }
    }

    private ThreadPoolExecutor createRpcCallbackExecutor(RpcOptions opts) {
        int callbackExecutorCorePoolSize = opts.getCallbackExecutorCorePoolSize();
        int callbackExecutorMaximumPoolSize = opts.getCallbackExecutorMaximumPoolSize();
        if (callbackExecutorCorePoolSize <= 0 || callbackExecutorMaximumPoolSize <= 0) {
            return null;
        }
        String name = "rheakv-pd-rpc-callback";
        return ThreadPoolUtil.newBuilder().poolName("rheakv-pd-rpc-callback").enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(callbackExecutorCorePoolSize)).maximumThreads(Integer.valueOf(callbackExecutorMaximumPoolSize)).keepAliveSeconds(Long.valueOf(120L)).workQueue(new ArrayBlockingQueue(opts.getCallbackExecutorQueueCapacity())).threadFactory((ThreadFactory)new NamedThreadFactory("rheakv-pd-rpc-callback", true)).rejectedHandler((RejectedExecutionHandler)new CallerRunsPolicyWithReport("rheakv-pd-rpc-callback")).build();
    }
}

