/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.RaftServiceFactory;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.rhea.JRaftHelper;
import com.alipay.sofa.jraft.rhea.client.RegionRouteTable;
import com.alipay.sofa.jraft.rhea.client.RoundRobinLoadBalancer;
import com.alipay.sofa.jraft.rhea.client.pd.DefaultPlacementDriverRpcService;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverRpcService;
import com.alipay.sofa.jraft.rhea.errors.RouteTableException;
import com.alipay.sofa.jraft.rhea.metadata.Peer;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.RegionEpoch;
import com.alipay.sofa.jraft.rhea.options.PlacementDriverOptions;
import com.alipay.sofa.jraft.rhea.options.RegionEngineOptions;
import com.alipay.sofa.jraft.rhea.options.RegionRouteTableOptions;
import com.alipay.sofa.jraft.rhea.options.RpcOptions;
import com.alipay.sofa.jraft.rhea.options.configured.RpcOptionsConfigured;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.Strings;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlacementDriverClient
implements PlacementDriverClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPlacementDriverClient.class);
    protected final RegionRouteTable regionRouteTable = new RegionRouteTable();
    protected final long clusterId;
    protected final String clusterName;
    protected CliService cliService;
    protected CliClientService cliClientService;
    protected RpcClient rpcClient;
    protected PlacementDriverRpcService pdRpcService;

    protected AbstractPlacementDriverClient(long clusterId, String clusterName) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
    }

    public synchronized boolean init(PlacementDriverOptions opts) {
        this.initCli(opts.getCliOptions());
        this.pdRpcService = new DefaultPlacementDriverRpcService(this);
        RpcOptions rpcOpts = opts.getPdRpcOptions();
        if (rpcOpts == null) {
            rpcOpts = RpcOptionsConfigured.newDefaultConfig();
            rpcOpts.setCallbackExecutorCorePoolSize(0);
            rpcOpts.setCallbackExecutorMaximumPoolSize(0);
        }
        if (!this.pdRpcService.init(rpcOpts)) {
            LOG.error("Fail to init [PlacementDriverRpcService].");
            return false;
        }
        List<RegionRouteTableOptions> regionRouteTableOptionsList = opts.getRegionRouteTableOptionsList();
        if (regionRouteTableOptionsList != null) {
            String initialServerList = opts.getInitialServerList();
            for (RegionRouteTableOptions regionRouteTableOpts : regionRouteTableOptionsList) {
                if (Strings.isBlank(regionRouteTableOpts.getInitialServerList())) {
                    regionRouteTableOpts.setInitialServerList(initialServerList);
                }
                this.initRouteTableByRegion(regionRouteTableOpts);
            }
        }
        return true;
    }

    public synchronized void shutdown() {
        if (this.cliService != null) {
            this.cliService.shutdown();
        }
        if (this.pdRpcService != null) {
            this.pdRpcService.shutdown();
        }
    }

    @Override
    public long getClusterId() {
        return this.clusterId;
    }

    @Override
    public Region getRegionById(long regionId) {
        return this.regionRouteTable.getRegionById(regionId);
    }

    @Override
    public Region findRegionByKey(byte[] key, boolean forceRefresh) {
        if (forceRefresh) {
            this.refreshRouteTable();
        }
        return this.regionRouteTable.findRegionByKey(key);
    }

    @Override
    public Map<Region, List<byte[]>> findRegionsByKeys(List<byte[]> keys, boolean forceRefresh) {
        if (forceRefresh) {
            this.refreshRouteTable();
        }
        return this.regionRouteTable.findRegionsByKeys(keys);
    }

    @Override
    public Map<Region, List<KVEntry>> findRegionsByKvEntries(List<KVEntry> kvEntries, boolean forceRefresh) {
        if (forceRefresh) {
            this.refreshRouteTable();
        }
        return this.regionRouteTable.findRegionsByKvEntries(kvEntries);
    }

    @Override
    public List<Region> findRegionsByKeyRange(byte[] startKey, byte[] endKey, boolean forceRefresh) {
        if (forceRefresh) {
            this.refreshRouteTable();
        }
        return this.regionRouteTable.findRegionsByKeyRange(startKey, endKey);
    }

    @Override
    public byte[] findStartKeyOfNextRegion(byte[] key, boolean forceRefresh) {
        if (forceRefresh) {
            this.refreshRouteTable();
        }
        return this.regionRouteTable.findStartKeyOfNextRegion(key);
    }

    @Override
    public RegionRouteTable getRegionRouteTable() {
        return this.regionRouteTable;
    }

    @Override
    public boolean transferLeader(long regionId, Peer peer, boolean refreshConf) {
        Requires.requireNonNull((Object)peer, (String)"peer");
        Requires.requireNonNull((Object)peer.getEndpoint(), (String)"peer.endpoint");
        String raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
        Configuration conf = RouteTable.getInstance().getConfiguration(raftGroupId);
        Status status = this.cliService.transferLeader(raftGroupId, conf, JRaftHelper.toJRaftPeerId(peer));
        if (status.isOk()) {
            if (refreshConf) {
                this.refreshRouteConfiguration(regionId);
            }
            return true;
        }
        LOG.error("Fail to [transferLeader], [regionId: {}, peer: {}], status: {}.", new Object[]{regionId, peer, status});
        return false;
    }

    @Override
    public boolean addReplica(long regionId, Peer peer, boolean refreshConf) {
        Requires.requireNonNull((Object)peer, (String)"peer");
        Requires.requireNonNull((Object)peer.getEndpoint(), (String)"peer.endpoint");
        String raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
        Configuration conf = RouteTable.getInstance().getConfiguration(raftGroupId);
        Status status = this.cliService.addPeer(raftGroupId, conf, JRaftHelper.toJRaftPeerId(peer));
        if (status.isOk()) {
            if (refreshConf) {
                this.refreshRouteConfiguration(regionId);
            }
            return true;
        }
        LOG.error("Fail to [addReplica], [regionId: {}, peer: {}], status: {}.", new Object[]{regionId, peer, status});
        return false;
    }

    @Override
    public boolean removeReplica(long regionId, Peer peer, boolean refreshConf) {
        Requires.requireNonNull((Object)peer, (String)"peer");
        Requires.requireNonNull((Object)peer.getEndpoint(), (String)"peer.endpoint");
        String raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
        Configuration conf = RouteTable.getInstance().getConfiguration(raftGroupId);
        Status status = this.cliService.removePeer(raftGroupId, conf, JRaftHelper.toJRaftPeerId(peer));
        if (status.isOk()) {
            if (refreshConf) {
                this.refreshRouteConfiguration(regionId);
            }
            return true;
        }
        LOG.error("Fail to [removeReplica], [regionId: {}, peer: {}], status: {}.", new Object[]{regionId, peer, status});
        return false;
    }

    @Override
    public Endpoint getLeader(long regionId, boolean forceRefresh, long timeoutMillis) {
        String raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
        PeerId leader = this.getLeader(raftGroupId, forceRefresh, timeoutMillis);
        if (leader == null && !forceRefresh) {
            leader = this.getLeader(raftGroupId, true, timeoutMillis);
        }
        if (leader == null) {
            throw new RouteTableException("no leader in group: " + raftGroupId);
        }
        return leader.getEndpoint();
    }

    protected PeerId getLeader(String raftGroupId, boolean forceRefresh, long timeoutMillis) {
        RouteTable routeTable;
        block7: {
            routeTable = RouteTable.getInstance();
            if (forceRefresh) {
                long deadline = System.currentTimeMillis() + timeoutMillis;
                StringBuilder error = new StringBuilder();
                Throwable lastCause = null;
                while (true) {
                    try {
                        Status st = routeTable.refreshLeader(this.cliClientService, raftGroupId, 2000);
                        if (st.isOk()) break block7;
                        error.append(st.toString());
                    }
                    catch (InterruptedException e) {
                        ThrowUtil.throwException(e);
                    }
                    catch (Throwable t) {
                        lastCause = t;
                        error.append(t.getMessage());
                    }
                    if (System.currentTimeMillis() >= deadline) break;
                    LOG.debug("Fail to find leader, retry again, {}.", (Object)error);
                    error.append(", ");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        ThrowUtil.throwException(e);
                    }
                }
                throw lastCause != null ? new RouteTableException(error.toString(), lastCause) : new RouteTableException(error.toString());
            }
        }
        return routeTable.selectLeader(raftGroupId);
    }

    @Override
    public Endpoint getLuckyPeer(long regionId, boolean forceRefresh, long timeoutMillis, Endpoint unExpect) {
        Configuration configs;
        RouteTable routeTable;
        String raftGroupId;
        block11: {
            raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
            routeTable = RouteTable.getInstance();
            if (forceRefresh) {
                long deadline = System.currentTimeMillis() + timeoutMillis;
                StringBuilder error = new StringBuilder();
                while (true) {
                    try {
                        Status st = routeTable.refreshConfiguration(this.cliClientService, raftGroupId, 5000);
                        if (st.isOk()) break block11;
                        error.append(st.toString());
                    }
                    catch (InterruptedException e) {
                        ThrowUtil.throwException(e);
                    }
                    catch (TimeoutException e) {
                        error.append(e.getMessage());
                    }
                    if (System.currentTimeMillis() >= deadline) break;
                    LOG.debug("Fail to get peers, retry again, {}.", (Object)error);
                    error.append(", ");
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        ThrowUtil.throwException(e);
                    }
                }
                throw new RouteTableException(error.toString());
            }
        }
        if ((configs = routeTable.getConfiguration(raftGroupId)) == null) {
            throw new RouteTableException("empty configs in group: " + raftGroupId);
        }
        List peerList = configs.getPeers();
        if (peerList == null || peerList.isEmpty()) {
            throw new RouteTableException("empty peers in group: " + raftGroupId);
        }
        int size = peerList.size();
        if (size == 1) {
            return ((PeerId)peerList.get(0)).getEndpoint();
        }
        RoundRobinLoadBalancer balancer = RoundRobinLoadBalancer.getInstance(regionId);
        for (int i = 0; i < size; ++i) {
            PeerId candidate = (PeerId)balancer.select(peerList);
            Endpoint luckyOne = candidate.getEndpoint();
            if (luckyOne.equals((Object)unExpect)) continue;
            return luckyOne;
        }
        throw new RouteTableException("have no choice in group(peers): " + raftGroupId);
    }

    @Override
    public void refreshRouteConfiguration(long regionId) {
        String raftGroupId = JRaftHelper.getJRaftGroupId(this.clusterName, regionId);
        try {
            this.getLeader(raftGroupId, true, 5000L);
            RouteTable.getInstance().refreshConfiguration(this.cliClientService, raftGroupId, 5000);
        }
        catch (Exception e) {
            LOG.error("Fail to refresh route configuration for {}, {}.", (Object)regionId, (Object)StackTraceUtil.stackTrace(e));
        }
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public PlacementDriverRpcService getPdRpcService() {
        return this.pdRpcService;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    protected void initRouteTableByRegion(RegionRouteTableOptions opts) {
        long regionId = (Long)Requires.requireNonNull((Object)opts.getRegionId(), (String)"opts.regionId");
        byte[] startKey = opts.getStartKeyBytes();
        byte[] endKey = opts.getEndKeyBytes();
        String initialServerList = opts.getInitialServerList();
        Region region = new Region();
        Configuration conf = new Configuration();
        region.setId(regionId);
        region.setStartKey(startKey);
        region.setEndKey(endKey);
        region.setRegionEpoch(new RegionEpoch(-1L, -1L));
        Requires.requireTrue((boolean)Strings.isNotBlank(initialServerList), (Object)"opts.initialServerList is blank");
        conf.parse(initialServerList);
        region.setPeers(JRaftHelper.toPeerList(conf.listPeers()));
        RouteTable.getInstance().updateConfiguration(JRaftHelper.getJRaftGroupId(this.clusterName, regionId), conf);
        this.regionRouteTable.addOrUpdateRegion(region);
    }

    protected Region getLocalRegionMetadata(RegionEngineOptions opts) {
        long regionId = (Long)Requires.requireNonNull((Object)opts.getRegionId(), (String)"opts.regionId");
        Requires.requireTrue((regionId >= -1L ? 1 : 0) != 0, (Object)"opts.regionId must >= -1");
        Requires.requireTrue((regionId < 1000000L ? 1 : 0) != 0, (Object)"opts.regionId must < 1000000");
        byte[] startKey = opts.getStartKeyBytes();
        byte[] endKey = opts.getEndKeyBytes();
        String initialServerList = opts.getInitialServerList();
        Region region = new Region();
        Configuration conf = new Configuration();
        region.setId(regionId);
        region.setStartKey(startKey);
        region.setEndKey(endKey);
        region.setRegionEpoch(new RegionEpoch(-1L, -1L));
        Requires.requireTrue((boolean)Strings.isNotBlank(initialServerList), (Object)"opts.initialServerList is blank");
        conf.parse(initialServerList);
        region.setPeers(JRaftHelper.toPeerList(conf.listPeers()));
        this.regionRouteTable.addOrUpdateRegion(region);
        return region;
    }

    protected void initCli(CliOptions cliOpts) {
        if (cliOpts == null) {
            cliOpts = new CliOptions();
            cliOpts.setTimeoutMs(5000);
            cliOpts.setMaxRetry(3);
        }
        this.cliService = RaftServiceFactory.createAndInitCliService((CliOptions)cliOpts);
        this.cliClientService = ((CliServiceImpl)this.cliService).getCliClientService();
        Requires.requireNonNull((Object)this.cliClientService, (String)"cliClientService");
        this.rpcClient = ((AbstractBoltClientService)this.cliClientService).getRpcClient();
    }

    protected abstract void refreshRouteTable();
}

