/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.rhea.client.FutureGroup;
import com.alipay.sofa.jraft.rhea.errors.NeverGetHereException;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FutureHelper {
    public static final long DEFAULT_TIMEOUT_MILLIS = SystemPropertyUtil.getLong((String)"rhea.default_future_timeout", (long)10000L);

    public static <V> V get(CompletableFuture<V> future) {
        return FutureHelper.get(future, DEFAULT_TIMEOUT_MILLIS);
    }

    public static <V> V get(CompletableFuture<V> future, long timeoutMillis) {
        try {
            return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ThrowUtil.throwException(e);
            throw NeverGetHereException.INSTANCE;
        }
    }

    public static CompletableFuture<Boolean> joinBooleans(FutureGroup<Boolean> futureGroup) {
        return FutureHelper.joinBooleans(futureGroup, new CompletableFuture<Boolean>());
    }

    public static CompletableFuture<Boolean> joinBooleans(FutureGroup<Boolean> futureGroup, CompletableFuture<Boolean> future) {
        CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                for (CompletableFuture partOf : futureGroup.futures()) {
                    if (((Boolean)partOf.join()).booleanValue()) continue;
                    future.complete(false);
                    return;
                }
                future.complete(true);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<List<T>> joinList(FutureGroup<List<T>> futureGroup) {
        return FutureHelper.joinList(futureGroup, 0);
    }

    public static <T> CompletableFuture<List<T>> joinList(FutureGroup<List<T>> futureGroup, int size) {
        return FutureHelper.joinList(futureGroup, size, new CompletableFuture<List<T>>());
    }

    public static <T> CompletableFuture<List<T>> joinList(FutureGroup<List<T>> futureGroup, int size, CompletableFuture<List<T>> future) {
        CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                ArrayList allResult = size > 0 ? Lists.newArrayListWithCapacity(size) : Lists.newArrayList();
                for (CompletableFuture partOf : futureGroup.futures()) {
                    allResult.addAll((Collection)partOf.join());
                }
                future.complete(allResult);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    public static <K, V> CompletableFuture<Map<K, V>> joinMap(FutureGroup<Map<K, V>> futureGroup) {
        return FutureHelper.joinMap(futureGroup, 0);
    }

    public static <K, V> CompletableFuture<Map<K, V>> joinMap(FutureGroup<Map<K, V>> futureGroup, int size) {
        return FutureHelper.joinMap(futureGroup, size, new CompletableFuture<Map<K, V>>());
    }

    public static <K, V> CompletableFuture<Map<K, V>> joinMap(FutureGroup<Map<K, V>> futureGroup, int size, CompletableFuture<Map<K, V>> future) {
        CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                HashMap allResult = size > 0 ? Maps.newHashMapWithExpectedSize(size) : Maps.newHashMap();
                for (CompletableFuture partOf : futureGroup.futures()) {
                    allResult.putAll((Map)partOf.join());
                }
                future.complete(allResult);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    private FutureHelper() {
    }
}

