/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.RaftServiceFactory;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.rhea.client.RheaKVCliService;
import com.alipay.sofa.jraft.rhea.cmd.store.BaseResponse;
import com.alipay.sofa.jraft.rhea.cmd.store.RangeSplitRequest;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.jraft.util.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRheaKVCliService
implements RheaKVCliService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRheaKVCliService.class);
    private RpcClient rpcClient;
    private CliService cliService;
    private CliOptions opts;
    private boolean started;

    public boolean init(CliOptions opts) {
        if (this.started) {
            LOG.info("[DefaultRheaKVRpcService] already started.");
            return true;
        }
        this.initCli(opts);
        LOG.info("[DefaultRheaKVCliService] start successfully, options: {}.", (Object)opts);
        this.started = true;
        return true;
    }

    public void shutdown() {
        if (this.cliService != null) {
            this.cliService.shutdown();
        }
        this.started = false;
        LOG.info("[DefaultRheaKVCliService] shutdown successfully.");
    }

    @Override
    public Status rangeSplit(long regionId, long newRegionId, String groupId, Configuration conf) {
        PeerId leaderId = new PeerId();
        Status st = this.cliService.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            throw new IllegalStateException(st.getErrorMsg());
        }
        RangeSplitRequest request = new RangeSplitRequest();
        request.setRegionId(regionId);
        request.setNewRegionId(newRegionId);
        try {
            BaseResponse response = (BaseResponse)this.rpcClient.invokeSync(leaderId.getEndpoint().toString(), (Object)request, this.opts.getTimeoutMs());
            if (response.isSuccess()) {
                return Status.OK();
            }
            return new Status(-1, "Fail to range split on region %d, error: %s", new Object[]{regionId, response});
        }
        catch (Exception e) {
            LOG.error("Fail to range split on exception: {}.", (Object)StackTraceUtil.stackTrace(e));
            return new Status(-1, "fail to range split on region %d", new Object[]{regionId});
        }
    }

    private void initCli(CliOptions cliOpts) {
        if (cliOpts == null) {
            cliOpts = new CliOptions();
            cliOpts.setTimeoutMs(5000);
            cliOpts.setMaxRetry(3);
        }
        this.opts = cliOpts;
        this.cliService = RaftServiceFactory.createAndInitCliService((CliOptions)cliOpts);
        CliClientService cliClientService = ((CliServiceImpl)this.cliService).getCliClientService();
        Requires.requireNonNull((Object)cliClientService, (String)"cliClientService");
        this.rpcClient = ((AbstractBoltClientService)cliClientService).getRpcClient();
    }
}

