/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.rhea.client.DefaultRheaKVStore;
import com.alipay.sofa.jraft.rhea.client.FutureHelper;
import com.alipay.sofa.jraft.rhea.errors.InvalidLockAcquirerException;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.ThrowUtil;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDistributedLock
extends DistributedLock<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDistributedLock.class);
    private final DefaultRheaKVStore rheaKVStore;
    private volatile ScheduledFuture<?> watchdogFuture;
    private volatile boolean mayCancelIfRunning = false;

    protected DefaultDistributedLock(byte[] target, long lease, TimeUnit unit, ScheduledExecutorService watchdog, DefaultRheaKVStore rheaKVStore) {
        super(target, lease, unit, watchdog);
        this.rheaKVStore = rheaKVStore;
    }

    @Override
    public void unlock() {
        byte[] internalKey = (byte[])this.getInternalKey();
        DistributedLock.Acquirer acquirer = this.getAcquirer();
        try {
            DistributedLock.Owner owner = this.rheaKVStore.releaseLockWith(internalKey, acquirer).get();
            this.updateOwner(owner);
            if (!owner.isSameAcquirer(acquirer)) {
                String message = String.format("an invalid acquirer [%s] trying to unlock, the real owner is [%s]", acquirer, owner);
                throw new InvalidLockAcquirerException(message);
            }
            if (owner.getAcquires() <= 0L) {
                this.tryCancelScheduling();
            }
        }
        catch (InvalidLockAcquirerException e) {
            LOG.error("Fail to unlock, {}.", (Object)StackTraceUtil.stackTrace(e));
            ThrowUtil.throwException(e);
        }
        catch (Throwable t) {
            LOG.error("Fail to unlock: {}, will cancel scheduling, {}.", (Object)acquirer, (Object)StackTraceUtil.stackTrace(t));
            this.tryCancelScheduling();
            ThrowUtil.throwException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DistributedLock.Owner internalTryLock(byte[] ctx) {
        byte[] internalKey = (byte[])this.getInternalKey();
        DistributedLock.Acquirer acquirer = this.getAcquirer();
        acquirer.setContext(ctx);
        CompletableFuture<DistributedLock.Owner> future = this.rheaKVStore.tryLockWith(internalKey, false, acquirer);
        DistributedLock.Owner owner = FutureHelper.get(future);
        if (!owner.isSuccess()) {
            this.updateOwner(owner);
            return owner;
        }
        this.updateOwnerAndAcquirer(owner);
        ScheduledExecutorService watchdog = this.getWatchdog();
        if (watchdog == null) {
            return owner;
        }
        if (this.watchdogFuture == null) {
            DefaultDistributedLock defaultDistributedLock = this;
            synchronized (defaultDistributedLock) {
                if (this.watchdogFuture == null) {
                    long period = acquirer.getLeaseMillis() / 3L << 1;
                    this.watchdogFuture = this.scheduleKeepingLease(watchdog, internalKey, acquirer, period);
                }
            }
        }
        return owner;
    }

    private ScheduledFuture<?> scheduleKeepingLease(ScheduledExecutorService watchdog, byte[] key, DistributedLock.Acquirer acquirer, long period) {
        return watchdog.scheduleAtFixedRate(() -> {
            try {
                if (this.mayCancelIfRunning) {
                    this.tryCancelScheduling();
                    return;
                }
                this.rheaKVStore.tryLockWith(key, true, acquirer).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        LOG.error("Fail to keeping lease with lock: {}, {}.", (Object)acquirer, (Object)StackTraceUtil.stackTrace(throwable));
                        this.tryCancelScheduling();
                        return;
                    }
                    if (!result.isSuccess()) {
                        LOG.warn("Fail to keeping lease with lock: {}, and result detail is: {}.", (Object)acquirer, result);
                        this.tryCancelScheduling();
                        return;
                    }
                    LOG.debug("Keeping lease with lock: {}.", (Object)acquirer);
                });
            }
            catch (Throwable t) {
                LOG.error("Fail to keeping lease with lock: {}, {}.", (Object)acquirer, (Object)StackTraceUtil.stackTrace(t));
                this.tryCancelScheduling();
            }
        }, period, period, TimeUnit.MILLISECONDS);
    }

    private void tryCancelScheduling() {
        if (this.watchdogFuture != null) {
            this.mayCancelIfRunning = true;
            this.watchdogFuture.cancel(true);
        }
    }
}

