/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.sofa.jraft.rhea.RegionKVService;
import com.alipay.sofa.jraft.rhea.RequestProcessClosure;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.cmd.store.BaseRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchDeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.CompareAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ContainsKeyRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRangeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyLockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyUnlockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MergeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MultiGetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.NoRegionFoundResponse;
import com.alipay.sofa.jraft.rhea.cmd.store.NodeExecuteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutIfAbsentRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.RangeSplitRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ResetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ScanRequest;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.RheaRuntimeException;
import com.alipay.sofa.jraft.util.Requires;
import java.util.concurrent.Executor;

public class KVCommandProcessor<T extends BaseRequest>
extends AsyncUserProcessor<T> {
    private final Class<T> reqClazz;
    private final StoreEngine storeEngine;

    public KVCommandProcessor(Class<T> reqClazz, StoreEngine storeEngine) {
        this.reqClazz = (Class)Requires.requireNonNull(reqClazz, (String)"reqClazz");
        this.storeEngine = (StoreEngine)Requires.requireNonNull((Object)storeEngine, (String)"storeEngine");
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, T request) {
        Requires.requireNonNull(request, (String)"request");
        RequestProcessClosure closure = new RequestProcessClosure((BaseRequest)request, bizCtx, asyncCtx);
        RegionKVService regionKVService = this.storeEngine.getRegionKVService(((BaseRequest)request).getRegionId());
        if (regionKVService == null) {
            NoRegionFoundResponse noRegion = new NoRegionFoundResponse();
            noRegion.setRegionId(((BaseRequest)request).getRegionId());
            noRegion.setError(Errors.NO_REGION_FOUND);
            noRegion.setValue(false);
            closure.sendResponse(noRegion);
            return;
        }
        switch (((BaseRequest)request).magic()) {
            case 1: {
                regionKVService.handlePutRequest((PutRequest)request, closure);
                break;
            }
            case 2: {
                regionKVService.handleBatchPutRequest((BatchPutRequest)request, closure);
                break;
            }
            case 3: {
                regionKVService.handlePutIfAbsentRequest((PutIfAbsentRequest)request, closure);
                break;
            }
            case 4: {
                regionKVService.handleGetAndPutRequest((GetAndPutRequest)request, closure);
                break;
            }
            case 17: {
                regionKVService.handleCompareAndPutRequest((CompareAndPutRequest)request, closure);
                break;
            }
            case 5: {
                regionKVService.handleDeleteRequest((DeleteRequest)request, closure);
                break;
            }
            case 6: {
                regionKVService.handleDeleteRangeRequest((DeleteRangeRequest)request, closure);
                break;
            }
            case 18: {
                regionKVService.handleBatchDeleteRequest((BatchDeleteRequest)request, closure);
                break;
            }
            case 7: {
                regionKVService.handleMergeRequest((MergeRequest)request, closure);
                break;
            }
            case 8: {
                regionKVService.handleGetRequest((GetRequest)request, closure);
                break;
            }
            case 9: {
                regionKVService.handleMultiGetRequest((MultiGetRequest)request, closure);
                break;
            }
            case 19: {
                regionKVService.handleContainsKeyRequest((ContainsKeyRequest)request, closure);
                break;
            }
            case 10: {
                regionKVService.handleScanRequest((ScanRequest)request, closure);
                break;
            }
            case 11: {
                regionKVService.handleGetSequence((GetSequenceRequest)request, closure);
                break;
            }
            case 12: {
                regionKVService.handleResetSequence((ResetSequenceRequest)request, closure);
                break;
            }
            case 13: {
                regionKVService.handleKeyLockRequest((KeyLockRequest)request, closure);
                break;
            }
            case 14: {
                regionKVService.handleKeyUnlockRequest((KeyUnlockRequest)request, closure);
                break;
            }
            case 15: {
                regionKVService.handleNodeExecuteRequest((NodeExecuteRequest)request, closure);
                break;
            }
            case 16: {
                regionKVService.handleRangeSplitRequest((RangeSplitRequest)request, closure);
                break;
            }
            default: {
                throw new RheaRuntimeException("Unsupported request type: " + request.getClass().getName());
            }
        }
    }

    public String interest() {
        return this.reqClazz.getName();
    }

    public Executor getExecutor() {
        return this.storeEngine.getKvRpcExecutor();
    }
}

