/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.impl;

import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.conf.ConfigurationManager;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.error.LogEntryCorruptedException;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.option.LogManagerOptions;
import com.alipay.sofa.jraft.option.LogStorageOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.storage.LogStorage;
import com.alipay.sofa.jraft.util.ArrayDeque;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.DisruptorBuilder;
import com.alipay.sofa.jraft.util.DisruptorMetricSet;
import com.alipay.sofa.jraft.util.LogExceptionHandler;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SegmentList;
import com.alipay.sofa.jraft.util.ThreadHelper;
import com.alipay.sofa.jraft.util.Utils;
import com.codahale.metrics.Metric;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManagerImpl
implements LogManager {
    private static final int APPEND_LOG_RETRY_TIMES = 50;
    private static final Logger LOG = LoggerFactory.getLogger(LogManagerImpl.class);
    private LogStorage logStorage;
    private ConfigurationManager configManager;
    private FSMCaller fsmCaller;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    private volatile boolean stopped;
    private volatile boolean hasError;
    private long nextWaitId;
    private LogId diskId = new LogId(0L, 0L);
    private LogId appliedId = new LogId(0L, 0L);
    private final SegmentList<LogEntry> logsInMemory = new SegmentList(true);
    private volatile long firstLogIndex;
    private volatile long lastLogIndex;
    private volatile LogId lastSnapshotId = new LogId(0L, 0L);
    private final Map<Long, WaitMeta> waitMap = new HashMap<Long, WaitMeta>();
    private Disruptor<StableClosureEvent> disruptor;
    private RingBuffer<StableClosureEvent> diskQueue;
    private RaftOptions raftOptions;
    private volatile CountDownLatch shutDownLatch;
    private NodeMetrics nodeMetrics;
    private final CopyOnWriteArrayList<LogManager.LastLogIndexListener> lastLogIndexListeners = new CopyOnWriteArrayList();

    @Override
    public void addLastLogIndexListener(LogManager.LastLogIndexListener listener) {
        this.lastLogIndexListeners.add(listener);
    }

    @Override
    public void removeLastLogIndexListener(LogManager.LastLogIndexListener listener) {
        this.lastLogIndexListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(LogManagerOptions opts) {
        this.writeLock.lock();
        try {
            if (opts.getLogStorage() == null) {
                LOG.error("Fail to init log manager, log storage is null");
                boolean bl = false;
                return bl;
            }
            this.raftOptions = opts.getRaftOptions();
            this.nodeMetrics = opts.getNodeMetrics();
            this.logStorage = opts.getLogStorage();
            this.configManager = opts.getConfigurationManager();
            LogStorageOptions lsOpts = new LogStorageOptions();
            lsOpts.setConfigurationManager(this.configManager);
            lsOpts.setLogEntryCodecFactory(opts.getLogEntryCodecFactory());
            if (!this.logStorage.init(lsOpts)) {
                LOG.error("Fail to init logStorage");
                boolean bl = false;
                return bl;
            }
            this.firstLogIndex = this.logStorage.getFirstLogIndex();
            this.lastLogIndex = this.logStorage.getLastLogIndex();
            this.diskId = new LogId(this.lastLogIndex, this.getTermFromLogStorage(this.lastLogIndex));
            this.fsmCaller = opts.getFsmCaller();
            this.disruptor = DisruptorBuilder.newInstance().setEventFactory(new StableClosureEventFactory()).setRingBufferSize(opts.getDisruptorBufferSize()).setThreadFactory(new NamedThreadFactory("JRaft-LogManager-Disruptor-", true)).setProducerType(ProducerType.MULTI).setWaitStrategy((WaitStrategy)new TimeoutBlockingWaitStrategy((long)this.raftOptions.getDisruptorPublishEventWaitTimeoutSecs(), TimeUnit.SECONDS)).build();
            this.disruptor.handleEventsWith(new EventHandler[]{new StableClosureEventHandler()});
            this.disruptor.setDefaultExceptionHandler(new LogExceptionHandler<Object>(this.getClass().getSimpleName(), (event, ex) -> this.reportError(-1, "LogManager handle event error", new Object[0])));
            this.diskQueue = this.disruptor.start();
            if (this.nodeMetrics.getMetricRegistry() != null) {
                this.nodeMetrics.getMetricRegistry().register("jraft-log-manager-disruptor", (Metric)new DisruptorMetricSet(this.diskQueue));
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    private void stopDiskThread() {
        this.shutDownLatch = new CountDownLatch(1);
        Utils.runInThread(() -> this.diskQueue.publishEvent((event, sequence) -> {
            event.reset();
            event.type = EventType.SHUTDOWN;
        }));
    }

    @Override
    public void join() throws InterruptedException {
        if (this.shutDownLatch == null) {
            return;
        }
        this.shutDownLatch.await();
        this.disruptor.shutdown();
    }

    @Override
    public void shutdown() {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            doUnlock = false;
            this.wakeupAllWaiter(this.writeLock);
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
        this.stopDiskThread();
    }

    private void clearMemoryLogs(LogId id) {
        this.writeLock.lock();
        try {
            this.logsInMemory.removeFromFirstWhen(entry -> entry.getId().compareTo(id) <= 0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendEntries(List<LogEntry> entries, LogManager.StableClosure done) {
        Requires.requireNonNull(done, "done");
        if (this.hasError) {
            entries.clear();
            Utils.runClosureInThread(done, new Status(RaftError.EIO, "Corrupted LogStorage", new Object[0]));
            return;
        }
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (!entries.isEmpty() && !this.checkAndResolveConflict(entries, done)) {
                entries.clear();
                return;
            }
            for (int i = 0; i < entries.size(); ++i) {
                LogEntry entry = entries.get(i);
                if (this.raftOptions.isEnableLogEntryChecksum()) {
                    entry.setChecksum(entry.checksum());
                }
                if (entry.getType() != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) continue;
                Configuration oldConf = new Configuration();
                if (entry.getOldPeers() != null) {
                    oldConf = new Configuration(entry.getOldPeers(), entry.getOldLearners());
                }
                ConfigurationEntry conf = new ConfigurationEntry(entry.getId(), new Configuration(entry.getPeers(), entry.getLearners()), oldConf);
                this.configManager.add(conf);
            }
            if (!entries.isEmpty()) {
                done.setFirstLogIndex(entries.get(0).getId().getIndex());
                this.logsInMemory.addAll(entries);
            }
            done.setEntries(entries);
            int retryTimes = 0;
            EventTranslator translator = (event, sequence) -> {
                event.reset();
                event.type = EventType.OTHER;
                event.done = done;
            };
            while (!this.tryOfferEvent(done, (EventTranslator<StableClosureEvent>)translator)) {
                if (++retryTimes > 50) {
                    this.reportError(RaftError.EBUSY.getNumber(), "LogManager is busy, disk queue overload.", new Object[0]);
                    return;
                }
                ThreadHelper.onSpinWait();
            }
            doUnlock = false;
            if (!this.wakeupAllWaiter(this.writeLock)) {
                this.notifyLastLogIndexListeners();
            }
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    private void offerEvent(LogManager.StableClosure done, EventType type) {
        if (this.stopped) {
            Utils.runClosureInThread(done, new Status(RaftError.ESTOP, "Log manager is stopped.", new Object[0]));
            return;
        }
        if (!this.diskQueue.tryPublishEvent((event, sequence) -> {
            event.reset();
            event.type = type;
            event.done = done;
        })) {
            this.reportError(RaftError.EBUSY.getNumber(), "Log manager is overload.", new Object[0]);
            Utils.runClosureInThread(done, new Status(RaftError.EBUSY, "Log manager is overload.", new Object[0]));
        }
    }

    private boolean tryOfferEvent(LogManager.StableClosure done, EventTranslator<StableClosureEvent> translator) {
        if (this.stopped) {
            Utils.runClosureInThread(done, new Status(RaftError.ESTOP, "Log manager is stopped.", new Object[0]));
            return true;
        }
        return this.diskQueue.tryPublishEvent(translator);
    }

    private void notifyLastLogIndexListeners() {
        for (int i = 0; i < this.lastLogIndexListeners.size(); ++i) {
            LogManager.LastLogIndexListener listener = this.lastLogIndexListeners.get(i);
            if (listener == null) continue;
            try {
                listener.onLastLogIndexChanged(this.lastLogIndex);
                continue;
            }
            catch (Exception e) {
                LOG.error("Fail to notify LastLogIndexListener, listener={}, index={}", (Object)listener, (Object)this.lastLogIndex);
            }
        }
    }

    private boolean wakeupAllWaiter(Lock lock) {
        if (this.waitMap.isEmpty()) {
            lock.unlock();
            return false;
        }
        ArrayList<WaitMeta> wms = new ArrayList<WaitMeta>(this.waitMap.values());
        int errCode = this.stopped ? RaftError.ESTOP.getNumber() : RaftError.SUCCESS.getNumber();
        this.waitMap.clear();
        lock.unlock();
        int waiterCount = wms.size();
        for (int i = 0; i < waiterCount; ++i) {
            WaitMeta wm = (WaitMeta)wms.get(i);
            wm.errorCode = errCode;
            Utils.runInThread(() -> this.runOnNewLog(wm));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogId appendToStorage(List<LogEntry> toAppend) {
        LogId lastId = null;
        if (!this.hasError) {
            long startMs = Utils.monotonicMs();
            int entriesCount = toAppend.size();
            this.nodeMetrics.recordSize("append-logs-count", entriesCount);
            try {
                int writtenSize = 0;
                for (int i = 0; i < entriesCount; ++i) {
                    LogEntry entry = toAppend.get(i);
                    writtenSize += entry.getData() != null ? entry.getData().remaining() : 0;
                }
                this.nodeMetrics.recordSize("append-logs-bytes", writtenSize);
                int nAppent = this.logStorage.appendEntries(toAppend);
                if (nAppent != entriesCount) {
                    LOG.error("**Critical error**, fail to appendEntries, nAppent={}, toAppend={}", (Object)nAppent, (Object)toAppend.size());
                    this.reportError(RaftError.EIO.getNumber(), "Fail to append log entries", new Object[0]);
                }
                if (nAppent > 0) {
                    lastId = toAppend.get(nAppent - 1).getId();
                }
                toAppend.clear();
            }
            finally {
                this.nodeMetrics.recordLatency("append-logs", Utils.monotonicMs() - startMs);
            }
        }
        return lastId;
    }

    private void reportError(int code, String fmt, Object ... args) {
        this.hasError = true;
        RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_LOG);
        error.setStatus(new Status(code, fmt, args));
        this.fsmCaller.onError(error);
    }

    private void setDiskId(LogId id) {
        LogId clearId;
        if (id == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (id.compareTo(this.diskId) < 0) {
                return;
            }
            this.diskId = id;
            clearId = this.diskId.compareTo(this.appliedId) <= 0 ? this.diskId : this.appliedId;
        }
        finally {
            this.writeLock.unlock();
        }
        if (clearId != null) {
            this.clearMemoryLogs(clearId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSnapshot(RaftOutter.SnapshotMeta meta) {
        LOG.debug("set snapshot: {}.", (Object)meta);
        this.writeLock.lock();
        try {
            if (meta.getLastIncludedIndex() <= this.lastSnapshotId.getIndex()) {
                return;
            }
            Configuration conf = this.confFromMeta(meta);
            Configuration oldConf = this.oldConfFromMeta(meta);
            ConfigurationEntry entry = new ConfigurationEntry(new LogId(meta.getLastIncludedIndex(), meta.getLastIncludedTerm()), conf, oldConf);
            this.configManager.setSnapshot(entry);
            long term = this.unsafeGetTerm(meta.getLastIncludedIndex());
            long savedLastSnapshotIndex = this.lastSnapshotId.getIndex();
            this.lastSnapshotId.setIndex(meta.getLastIncludedIndex());
            this.lastSnapshotId.setTerm(meta.getLastIncludedTerm());
            if (this.lastSnapshotId.compareTo(this.appliedId) > 0) {
                this.appliedId = this.lastSnapshotId.copy();
            }
            if (this.lastSnapshotId.compareTo(this.diskId) > 0) {
                this.diskId = this.lastSnapshotId.copy();
            }
            if (term == 0L) {
                this.truncatePrefix(meta.getLastIncludedIndex() + 1L);
            } else if (term == meta.getLastIncludedTerm()) {
                if (savedLastSnapshotIndex > 0L) {
                    this.truncatePrefix(savedLastSnapshotIndex + 1L);
                }
            } else if (!this.reset(meta.getLastIncludedIndex() + 1L)) {
                LOG.warn("Reset log manager failed, nextLogIndex={}.", (Object)(meta.getLastIncludedIndex() + 1L));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Configuration oldConfFromMeta(RaftOutter.SnapshotMeta meta) {
        PeerId peer;
        int i;
        Configuration oldConf = new Configuration();
        for (i = 0; i < meta.getOldPeersCount(); ++i) {
            peer = new PeerId();
            peer.parse(meta.getOldPeers(i));
            oldConf.addPeer(peer);
        }
        for (i = 0; i < meta.getOldLearnersCount(); ++i) {
            peer = new PeerId();
            peer.parse(meta.getOldLearners(i));
            oldConf.addLearner(peer);
        }
        return oldConf;
    }

    private Configuration confFromMeta(RaftOutter.SnapshotMeta meta) {
        PeerId peer;
        int i;
        Configuration conf = new Configuration();
        for (i = 0; i < meta.getPeersCount(); ++i) {
            peer = new PeerId();
            peer.parse(meta.getPeers(i));
            conf.addPeer(peer);
        }
        for (i = 0; i < meta.getLearnersCount(); ++i) {
            peer = new PeerId();
            peer.parse(meta.getLearners(i));
            conf.addLearner(peer);
        }
        return conf;
    }

    @Override
    public void clearBufferedLogs() {
        this.writeLock.lock();
        try {
            if (this.lastSnapshotId.getIndex() != 0L) {
                this.truncatePrefix(this.lastSnapshotId.getIndex() + 1L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String descLogsInMemory() {
        StringBuilder sb = new StringBuilder();
        boolean wasFirst = true;
        for (int i = 0; i < this.logsInMemory.size(); ++i) {
            LogEntry logEntry = this.logsInMemory.get(i);
            if (!wasFirst) {
                sb.append(",");
            } else {
                wasFirst = false;
            }
            sb.append("<id:(").append(logEntry.getId().getTerm()).append(",").append(logEntry.getId().getIndex()).append("),type:").append((Object)logEntry.getType()).append(">");
        }
        return sb.toString();
    }

    protected LogEntry getEntryFromMemory(long index) {
        LogEntry entry = null;
        if (!this.logsInMemory.isEmpty()) {
            long firstIndex = this.logsInMemory.peekFirst().getId().getIndex();
            long lastIndex = this.logsInMemory.peekLast().getId().getIndex();
            if (lastIndex - firstIndex + 1L != (long)this.logsInMemory.size()) {
                throw new IllegalStateException(String.format("lastIndex=%d,firstIndex=%d,logsInMemory=[%s]", lastIndex, firstIndex, this.descLogsInMemory()));
            }
            if (index >= firstIndex && index <= lastIndex) {
                entry = this.logsInMemory.get((int)(index - firstIndex));
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        LogEntry entry;
        this.readLock.lock();
        try {
            if (index > this.lastLogIndex || index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            entry = this.getEntryFromMemory(index);
            if (entry != null) {
                LogEntry logEntry = entry;
                return logEntry;
            }
        }
        finally {
            this.readLock.unlock();
        }
        entry = this.logStorage.getEntry(index);
        if (entry == null) {
            this.reportError(RaftError.EIO.getNumber(), "Corrupted entry at index=%d, not found", index);
        }
        if (entry != null && this.raftOptions.isEnableLogEntryChecksum() && entry.isCorrupted()) {
            String msg = String.format("Corrupted entry at index=%d, term=%d, expectedChecksum=%d, realChecksum=%d", index, entry.getId().getTerm(), entry.getChecksum(), entry.checksum());
            this.reportError(RaftError.EIO.getNumber(), msg, new Object[0]);
            throw new LogEntryCorruptedException(msg);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTerm(long index) {
        if (index == 0L) {
            return 0L;
        }
        this.readLock.lock();
        try {
            if (index == this.lastSnapshotId.getIndex()) {
                long l = this.lastSnapshotId.getTerm();
                return l;
            }
            if (index > this.lastLogIndex || index < this.firstLogIndex) {
                long l = 0L;
                return l;
            }
            LogEntry entry = this.getEntryFromMemory(index);
            if (entry != null) {
                long l = entry.getId().getTerm();
                return l;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getTermFromLogStorage(index);
    }

    private long getTermFromLogStorage(long index) {
        LogEntry entry = this.logStorage.getEntry(index);
        if (entry != null) {
            if (this.raftOptions.isEnableLogEntryChecksum() && entry.isCorrupted()) {
                String msg = String.format("The log entry is corrupted, index=%d, term=%d, expectedChecksum=%d, realChecksum=%d", entry.getId().getIndex(), entry.getId().getTerm(), entry.getChecksum(), entry.checksum());
                this.reportError(RaftError.EIO.getNumber(), msg, new Object[0]);
                throw new LogEntryCorruptedException(msg);
            }
            return entry.getId().getTerm();
        }
        return 0L;
    }

    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            long l = this.firstLogIndex;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLastLogIndex() {
        return this.getLastLogIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastLogIndex(boolean isFlush) {
        LastLogIdClosure c;
        this.readLock.lock();
        try {
            if (!isFlush) {
                long l = this.lastLogIndex;
                return l;
            }
            if (this.lastLogIndex == this.lastSnapshotId.getIndex()) {
                long l = this.lastLogIndex;
                return l;
            }
            c = new LastLogIdClosure();
            this.offerEvent(c, EventType.LAST_LOG_ID);
        }
        finally {
            this.readLock.unlock();
        }
        try {
            c.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return c.lastLogId.getIndex();
    }

    private long unsafeGetTerm(long index) {
        if (index == 0L) {
            return 0L;
        }
        LogId lss = this.lastSnapshotId;
        if (index == lss.getIndex()) {
            return lss.getTerm();
        }
        if (index > this.lastLogIndex || index < this.firstLogIndex) {
            return 0L;
        }
        LogEntry entry = this.getEntryFromMemory(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return this.getTermFromLogStorage(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogId getLastLogId(boolean isFlush) {
        LastLogIdClosure c;
        this.readLock.lock();
        try {
            if (!isFlush) {
                if (this.lastLogIndex >= this.firstLogIndex) {
                    LogId logId = new LogId(this.lastLogIndex, this.unsafeGetTerm(this.lastLogIndex));
                    return logId;
                }
                LogId logId = this.lastSnapshotId;
                return logId;
            }
            if (this.lastLogIndex == this.lastSnapshotId.getIndex()) {
                LogId logId = this.lastSnapshotId;
                return logId;
            }
            c = new LastLogIdClosure();
            this.offerEvent(c, EventType.LAST_LOG_ID);
        }
        finally {
            this.readLock.unlock();
        }
        try {
            c.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return c.lastLogId;
    }

    private boolean truncatePrefix(long firstIndexKept) {
        this.logsInMemory.removeFromFirstWhen(entry -> entry.getId().getIndex() < firstIndexKept);
        Requires.requireTrue(firstIndexKept >= this.firstLogIndex, "Try to truncate logs before %d, but the firstLogIndex is %d", firstIndexKept, this.firstLogIndex);
        this.firstLogIndex = firstIndexKept;
        if (firstIndexKept > this.lastLogIndex) {
            this.lastLogIndex = firstIndexKept - 1L;
        }
        LOG.debug("Truncate prefix, firstIndexKept is :{}", (Object)firstIndexKept);
        this.configManager.truncatePrefix(firstIndexKept);
        TruncatePrefixClosure c = new TruncatePrefixClosure(firstIndexKept);
        this.offerEvent(c, EventType.TRUNCATE_PREFIX);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reset(long nextLogIndex) {
        this.writeLock.lock();
        try {
            this.logsInMemory.clear();
            this.firstLogIndex = nextLogIndex;
            this.lastLogIndex = nextLogIndex - 1L;
            this.configManager.truncatePrefix(this.firstLogIndex);
            this.configManager.truncateSuffix(this.lastLogIndex);
            ResetClosure c = new ResetClosure(nextLogIndex);
            this.offerEvent(c, EventType.RESET);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void unsafeTruncateSuffix(long lastIndexKept) {
        if (lastIndexKept < this.appliedId.getIndex()) {
            LOG.error("FATAL ERROR: Can't truncate logs before appliedId={}, lastIndexKept={}", (Object)this.appliedId, (Object)lastIndexKept);
            return;
        }
        this.logsInMemory.removeFromLastWhen(entry -> entry.getId().getIndex() > lastIndexKept);
        this.lastLogIndex = lastIndexKept;
        long lastTermKept = this.unsafeGetTerm(lastIndexKept);
        Requires.requireTrue(this.lastLogIndex == 0L || lastTermKept != 0L);
        LOG.debug("Truncate suffix :{}", (Object)lastIndexKept);
        this.configManager.truncateSuffix(lastIndexKept);
        TruncateSuffixClosure c = new TruncateSuffixClosure(lastIndexKept, lastTermKept);
        this.offerEvent(c, EventType.TRUNCATE_SUFFIX);
    }

    private boolean checkAndResolveConflict(List<LogEntry> entries, LogManager.StableClosure done) {
        LogEntry firstLogEntry = ArrayDeque.peekFirst(entries);
        if (firstLogEntry.getId().getIndex() == 0L) {
            for (int i = 0; i < entries.size(); ++i) {
                entries.get(i).getId().setIndex(++this.lastLogIndex);
            }
            return true;
        }
        if (firstLogEntry.getId().getIndex() > this.lastLogIndex + 1L) {
            Utils.runClosureInThread(done, new Status(RaftError.EINVAL, "There's gap between first_index=%d and last_log_index=%d", firstLogEntry.getId().getIndex(), this.lastLogIndex));
            return false;
        }
        long appliedIndex = this.appliedId.getIndex();
        LogEntry lastLogEntry = ArrayDeque.peekLast(entries);
        if (lastLogEntry.getId().getIndex() <= appliedIndex) {
            LOG.warn("Received entries of which the lastLog={} is not greater than appliedIndex={}, return immediately with nothing changed.", (Object)lastLogEntry.getId().getIndex(), (Object)appliedIndex);
            Utils.runClosureInThread(done);
            return false;
        }
        if (firstLogEntry.getId().getIndex() == this.lastLogIndex + 1L) {
            this.lastLogIndex = lastLogEntry.getId().getIndex();
        } else {
            int conflictingIndex;
            for (conflictingIndex = 0; conflictingIndex < entries.size() && this.unsafeGetTerm(entries.get(conflictingIndex).getId().getIndex()) == entries.get(conflictingIndex).getId().getTerm(); ++conflictingIndex) {
            }
            if (conflictingIndex != entries.size()) {
                if (entries.get(conflictingIndex).getId().getIndex() <= this.lastLogIndex) {
                    this.unsafeTruncateSuffix(entries.get(conflictingIndex).getId().getIndex() - 1L);
                }
                this.lastLogIndex = lastLogEntry.getId().getIndex();
            }
            if (conflictingIndex > 0) {
                entries.subList(0, conflictingIndex).clear();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationEntry getConfiguration(long index) {
        this.readLock.lock();
        try {
            ConfigurationEntry configurationEntry = this.configManager.get(index);
            return configurationEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationEntry checkAndSetConfiguration(ConfigurationEntry current) {
        if (current == null) {
            return null;
        }
        this.readLock.lock();
        try {
            ConfigurationEntry lastConf = this.configManager.getLastConfiguration();
            if (lastConf != null && !lastConf.isEmpty() && !current.getId().equals(lastConf.getId())) {
                ConfigurationEntry configurationEntry = lastConf;
                return configurationEntry;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return current;
    }

    @Override
    public long wait(long expectedLastLogIndex, LogManager.NewLogCallback cb, Object arg) {
        WaitMeta wm = new WaitMeta(cb, arg, 0);
        return this.notifyOnNewLog(expectedLastLogIndex, wm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long notifyOnNewLog(long expectedLastLogIndex, WaitMeta wm) {
        this.writeLock.lock();
        try {
            if (expectedLastLogIndex != this.lastLogIndex || this.stopped) {
                wm.errorCode = this.stopped ? RaftError.ESTOP.getNumber() : 0;
                Utils.runInThread(() -> this.runOnNewLog(wm));
                long l = 0L;
                return l;
            }
            if (this.nextWaitId == 0L) {
                ++this.nextWaitId;
            }
            long waitId = this.nextWaitId++;
            this.waitMap.put(waitId, wm);
            long l = waitId;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWaiter(long id) {
        this.writeLock.lock();
        try {
            boolean bl = this.waitMap.remove(id) != null;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setAppliedId(LogId appliedId) {
        LogId clearId;
        this.writeLock.lock();
        try {
            if (appliedId.compareTo(this.appliedId) < 0) {
                return;
            }
            this.appliedId = appliedId.copy();
            clearId = this.diskId.compareTo(this.appliedId) <= 0 ? this.diskId : this.appliedId;
        }
        finally {
            this.writeLock.unlock();
        }
        if (clearId != null) {
            this.clearMemoryLogs(clearId);
        }
    }

    void runOnNewLog(WaitMeta wm) {
        wm.onNewLog.onNewLog(wm.arg, wm.errorCode);
    }

    @Override
    public Status checkConsistency() {
        this.readLock.lock();
        try {
            Requires.requireTrue(this.firstLogIndex > 0L);
            Requires.requireTrue(this.lastLogIndex >= 0L);
            if (this.lastSnapshotId.equals(new LogId(0L, 0L))) {
                if (this.firstLogIndex == 1L) {
                    Status status = Status.OK();
                    return status;
                }
                Status status = new Status(RaftError.EIO, "Missing logs in (0, %d)", this.firstLogIndex);
                return status;
            }
            if (this.lastSnapshotId.getIndex() >= this.firstLogIndex - 1L && this.lastSnapshotId.getIndex() <= this.lastLogIndex) {
                Status status = Status.OK();
                return status;
            }
            Status status = new Status(RaftError.EIO, "There's a gap between snapshot={%d, %d} and log=[%d, %d] ", this.lastSnapshotId.toString(), this.lastSnapshotId.getTerm(), this.firstLogIndex, this.lastLogIndex);
            return status;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(Describer.Printer out) {
        String _lastSnapshotId;
        String _appliedId;
        String _diskId;
        long _lastLogIndex;
        long _firstLogIndex;
        this.readLock.lock();
        try {
            _firstLogIndex = this.firstLogIndex;
            _lastLogIndex = this.lastLogIndex;
            _diskId = String.valueOf(this.diskId);
            _appliedId = String.valueOf(this.appliedId);
            _lastSnapshotId = String.valueOf(this.lastSnapshotId);
        }
        finally {
            this.readLock.unlock();
        }
        out.print("  storage: [").print(_firstLogIndex).print(", ").print(_lastLogIndex).println(Character.valueOf(']'));
        out.print("  diskId: ").println(_diskId);
        out.print("  appliedId: ").println(_appliedId);
        out.print("  lastSnapshotId: ").println(_lastSnapshotId);
    }

    private static class ResetClosure
    extends LogManager.StableClosure {
        long nextLogIndex;

        public ResetClosure(long nextLogIndex) {
            super(null);
            this.nextLogIndex = nextLogIndex;
        }

        @Override
        public void run(Status status) {
        }
    }

    private static class TruncateSuffixClosure
    extends LogManager.StableClosure {
        long lastIndexKept;
        long lastTermKept;

        public TruncateSuffixClosure(long lastIndexKept, long lastTermKept) {
            super(null);
            this.lastIndexKept = lastIndexKept;
            this.lastTermKept = lastTermKept;
        }

        @Override
        public void run(Status status) {
        }
    }

    private static class TruncatePrefixClosure
    extends LogManager.StableClosure {
        long firstIndexKept;

        public TruncatePrefixClosure(long firstIndexKept) {
            super(null);
            this.firstIndexKept = firstIndexKept;
        }

        @Override
        public void run(Status status) {
        }
    }

    private class StableClosureEventHandler
    implements EventHandler<StableClosureEvent> {
        LogId lastId;
        List<LogManager.StableClosure> storage;
        AppendBatcher ab;

        private StableClosureEventHandler() {
            this.lastId = LogManagerImpl.this.diskId;
            this.storage = new ArrayList<LogManager.StableClosure>(256);
            this.ab = new AppendBatcher(this.storage, 256, new ArrayList<LogEntry>(), LogManagerImpl.this.diskId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(StableClosureEvent event, long sequence, boolean endOfBatch) throws Exception {
            if (event.type == EventType.SHUTDOWN) {
                this.lastId = this.ab.flush();
                LogManagerImpl.this.setDiskId(this.lastId);
                LogManagerImpl.this.shutDownLatch.countDown();
                return;
            }
            LogManager.StableClosure done = event.done;
            if (done.getEntries() != null && !done.getEntries().isEmpty()) {
                this.ab.append(done);
            } else {
                this.lastId = this.ab.flush();
                boolean ret = true;
                switch (event.type) {
                    case LAST_LOG_ID: {
                        ((LastLogIdClosure)done).setLastLogId(this.lastId.copy());
                        break;
                    }
                    case TRUNCATE_PREFIX: {
                        long startMs = Utils.monotonicMs();
                        try {
                            TruncatePrefixClosure tpc = (TruncatePrefixClosure)done;
                            LOG.debug("Truncating storage to firstIndexKept={}.", (Object)tpc.firstIndexKept);
                            ret = LogManagerImpl.this.logStorage.truncatePrefix(tpc.firstIndexKept);
                            break;
                        }
                        finally {
                            LogManagerImpl.this.nodeMetrics.recordLatency("truncate-log-prefix", Utils.monotonicMs() - startMs);
                        }
                    }
                    case TRUNCATE_SUFFIX: {
                        long startMs = Utils.monotonicMs();
                        try {
                            TruncateSuffixClosure tsc = (TruncateSuffixClosure)done;
                            LOG.warn("Truncating storage to lastIndexKept={}.", (Object)tsc.lastIndexKept);
                            ret = LogManagerImpl.this.logStorage.truncateSuffix(tsc.lastIndexKept);
                            if (!ret) break;
                            this.lastId.setIndex(tsc.lastIndexKept);
                            this.lastId.setTerm(tsc.lastTermKept);
                            Requires.requireTrue(this.lastId.getIndex() == 0L || this.lastId.getTerm() != 0L);
                            break;
                        }
                        finally {
                            LogManagerImpl.this.nodeMetrics.recordLatency("truncate-log-suffix", Utils.monotonicMs() - startMs);
                        }
                    }
                    case RESET: {
                        ResetClosure rc = (ResetClosure)done;
                        LOG.info("Resetting storage to nextLogIndex={}.", (Object)rc.nextLogIndex);
                        ret = LogManagerImpl.this.logStorage.reset(rc.nextLogIndex);
                        break;
                    }
                }
                if (!ret) {
                    LogManagerImpl.this.reportError(RaftError.EIO.getNumber(), "Failed operation in LogStorage", new Object[0]);
                } else {
                    done.run(Status.OK());
                }
            }
            if (endOfBatch) {
                this.lastId = this.ab.flush();
                LogManagerImpl.this.setDiskId(this.lastId);
            }
        }
    }

    private class AppendBatcher {
        List<LogManager.StableClosure> storage;
        int cap;
        int size;
        int bufferSize;
        List<LogEntry> toAppend;
        LogId lastId;

        public AppendBatcher(List<LogManager.StableClosure> storage, int cap, List<LogEntry> toAppend, LogId lastId) {
            this.storage = storage;
            this.cap = cap;
            this.toAppend = toAppend;
            this.lastId = lastId;
        }

        LogId flush() {
            if (this.size > 0) {
                this.lastId = LogManagerImpl.this.appendToStorage(this.toAppend);
                for (int i = 0; i < this.size; ++i) {
                    this.storage.get(i).getEntries().clear();
                    Status st = null;
                    try {
                        st = LogManagerImpl.this.hasError ? new Status(RaftError.EIO, "Corrupted LogStorage", new Object[0]) : Status.OK();
                        this.storage.get(i).run(st);
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.error("Fail to run closure with status: {}.", (Object)st, (Object)t);
                    }
                }
                this.toAppend.clear();
                this.storage.clear();
            }
            this.size = 0;
            this.bufferSize = 0;
            return this.lastId;
        }

        void append(LogManager.StableClosure done) {
            if (this.size == this.cap || this.bufferSize >= LogManagerImpl.this.raftOptions.getMaxAppendBufferSize()) {
                this.flush();
            }
            this.storage.add(done);
            ++this.size;
            this.toAppend.addAll(done.getEntries());
            for (LogEntry entry : done.getEntries()) {
                this.bufferSize += entry.getData() != null ? entry.getData().remaining() : 0;
            }
        }
    }

    private static class LastLogIdClosure
    extends LogManager.StableClosure {
        private LogId lastLogId;
        private final CountDownLatch latch = new CountDownLatch(1);

        public LastLogIdClosure() {
            super(null);
        }

        void setLastLogId(LogId logId) {
            Requires.requireTrue(logId.getIndex() == 0L || logId.getTerm() != 0L);
            this.lastLogId = logId;
        }

        @Override
        public void run(Status status) {
            this.latch.countDown();
        }

        void await() throws InterruptedException {
            this.latch.await();
        }
    }

    private static class WaitMeta {
        LogManager.NewLogCallback onNewLog;
        int errorCode;
        Object arg;

        public WaitMeta(LogManager.NewLogCallback onNewLog, Object arg, int errorCode) {
            this.onNewLog = onNewLog;
            this.arg = arg;
            this.errorCode = errorCode;
        }
    }

    private static class StableClosureEventFactory
    implements EventFactory<StableClosureEvent> {
        private StableClosureEventFactory() {
        }

        public StableClosureEvent newInstance() {
            return new StableClosureEvent();
        }
    }

    private static class StableClosureEvent {
        LogManager.StableClosure done;
        EventType type;

        private StableClosureEvent() {
        }

        void reset() {
            this.done = null;
            this.type = null;
        }
    }

    private static enum EventType {
        OTHER,
        RESET,
        TRUNCATE_PREFIX,
        TRUNCATE_SUFFIX,
        SHUTDOWN,
        LAST_LOG_ID;

    }
}

