/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.remote;

import com.alipay.sofa.jraft.core.TimerManager;
import com.alipay.sofa.jraft.option.CopyOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.SnapshotCopierOptions;
import com.alipay.sofa.jraft.rpc.RaftClientService;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.snapshot.remote.BoltSession;
import com.alipay.sofa.jraft.storage.snapshot.remote.Session;
import com.alipay.sofa.jraft.util.ByteBufferCollector;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFileCopier {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFileCopier.class);
    private long readId;
    private RaftClientService rpcService;
    private Endpoint endpoint;
    private RaftOptions raftOptions;
    private TimerManager timerManager;
    private SnapshotThrottle snapshotThrottle;

    @OnlyForTest
    long getReaderId() {
        return this.readId;
    }

    @OnlyForTest
    Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean init(String uri, SnapshotThrottle snapshotThrottle, SnapshotCopierOptions opts) {
        this.rpcService = opts.getRaftClientService();
        this.timerManager = opts.getTimerManager();
        this.raftOptions = opts.getRaftOptions();
        this.snapshotThrottle = snapshotThrottle;
        int prefixSize = "remote://".length();
        if (uri == null || !uri.startsWith("remote://")) {
            LOG.error("Invalid uri {}.", (Object)uri);
            return false;
        }
        uri = uri.substring(prefixSize);
        int slasPos = uri.indexOf(47);
        String ipAndPort = uri.substring(0, slasPos);
        uri = uri.substring(slasPos + 1);
        try {
            this.readId = Long.parseLong(uri);
            String[] ipAndPortStrs = ipAndPort.split(":");
            this.endpoint = new Endpoint(ipAndPortStrs[0], Integer.parseInt(ipAndPortStrs[1]));
        }
        catch (Exception e) {
            LOG.error("Fail to parse readerId or endpoint.", (Throwable)e);
            return false;
        }
        if (!this.rpcService.connect(this.endpoint)) {
            LOG.error("Fail to init channel to {}.", (Object)this.endpoint);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyToFile(String source, String destPath, CopyOptions opts) throws IOException, InterruptedException {
        Session session = this.startCopyToFile(source, destPath, opts);
        if (session == null) {
            return false;
        }
        try {
            session.join();
            boolean bl = session.status().isOk();
            return bl;
        }
        finally {
            Utils.closeQuietly(session);
        }
    }

    public Session startCopyToFile(String source, String destPath, CopyOptions opts) throws IOException {
        File file = new File(destPath);
        if (file.exists() && !file.delete()) {
            LOG.error("Fail to delete destPath: {}.", (Object)destPath);
            return null;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, false){

            @Override
            public void close() throws IOException {
                this.getFD().sync();
                super.close();
            }
        });
        BoltSession session = this.newBoltSession(source);
        session.setOutputStream(out);
        session.setDestPath(destPath);
        session.setDestBuf(null);
        if (opts != null) {
            session.setCopyOptions(opts);
        }
        session.sendNextRpc();
        return session;
    }

    private BoltSession newBoltSession(String source) {
        RpcRequests.GetFileRequest.Builder reqBuilder = RpcRequests.GetFileRequest.newBuilder().setFilename(source).setReaderId(this.readId);
        return new BoltSession(this.rpcService, this.timerManager, this.snapshotThrottle, this.raftOptions, reqBuilder, this.endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy2IoBuffer(String source, ByteBufferCollector destBuf, CopyOptions opt) throws InterruptedException {
        Session session = this.startCopy2IoBuffer(source, destBuf, opt);
        if (session == null) {
            return false;
        }
        try {
            session.join();
            boolean bl = session.status().isOk();
            return bl;
        }
        finally {
            Utils.closeQuietly(session);
        }
    }

    public Session startCopy2IoBuffer(String source, ByteBufferCollector destBuf, CopyOptions opts) {
        BoltSession session = this.newBoltSession(source);
        session.setOutputStream(null);
        session.setDestBuf(destBuf);
        if (opts != null) {
            session.setCopyOptions(opts);
        }
        session.sendNextRpc();
        return session;
    }
}

