/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.jraft.error.LogEntryCorruptedException;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.impl.RocksDBLogStorage;
import com.alipay.sofa.jraft.storage.log.AbortFile;
import com.alipay.sofa.jraft.storage.log.CheckpointFile;
import com.alipay.sofa.jraft.storage.log.SegmentFile;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBSegmentLogStorage
extends RocksDBLogStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBSegmentLogStorage.class);
    private static final int DEFAULT_CHECKPOINT_INTERVAL_MS = SystemPropertyUtil.getInt("jraft.log_storage.segment.checkpoint.interval.ms", 5000);
    private static final int LOCATION_METADATA_SIZE = SegmentFile.MAGIC_BYTES_SIZE + 2 + 8 + 4;
    private static final int MAX_SEGMENT_FILE_SIZE = SystemPropertyUtil.getInt("jraft.log_storage.segment.max.size.bytes", 0x40000000);
    private static int DEFAULT_VALUE_SIZE_THRESHOLD = SystemPropertyUtil.getInt("jraft.log_storage.segment.value.threshold.bytes", 4096);
    private final int valueSizeThreshold;
    private final String segmentsPath;
    private final CheckpointFile checkpointFile;
    private List<SegmentFile> segments;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private ScheduledExecutorService checkpointExecutor;
    private final AbortFile abortFile;
    private static final Pattern SEGMENT_FILE_NAME_PATTERN = Pattern.compile("[0-9]+");

    public RocksDBSegmentLogStorage(String path, RaftOptions raftOptions) {
        this(path, raftOptions, DEFAULT_VALUE_SIZE_THRESHOLD);
    }

    public RocksDBSegmentLogStorage(String path, RaftOptions raftOptions, int valueSizeThreshold) {
        super(path, raftOptions);
        this.segmentsPath = path + File.separator + "segments";
        this.abortFile = new AbortFile(this.segmentsPath + File.separator + "abort");
        this.checkpointFile = new CheckpointFile(this.segmentsPath + File.separator + "checkpoint");
        this.valueSizeThreshold = valueSizeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile getLastSegmentFile(long logIndex, int waitToWroteSize, boolean createIfNecessary) throws IOException {
        this.readLock.lock();
        try {
            SegmentFile segmentFile = this.getLastSegmentFileUnLock(logIndex, waitToWroteSize, createIfNecessary);
            return segmentFile;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private SegmentFile getLastSegmentFileUnLock(long logIndex, int waitToWroteSize, boolean createIfNecessary) throws IOException {
        SegmentFile currLastFile;
        SegmentFile lastFile = null;
        if (!this.segments.isEmpty() && !(currLastFile = this.segments.get(this.segments.size() - 1)).reachesFileEndBy(waitToWroteSize)) {
            lastFile = currLastFile;
        }
        if (lastFile == null && createIfNecessary) {
            lastFile = this.createNewSegmentFile(logIndex);
        }
        return lastFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile createNewSegmentFile(long logIndex) throws IOException {
        this.writeLock.lock();
        try {
            if (!this.segments.isEmpty()) {
                SegmentFile currLastFile = this.segments.get(this.segments.size() - 1);
                currLastFile.sync();
                currLastFile.setLastLogIndex(logIndex - 1L);
            }
            SegmentFile segmentFile = new SegmentFile(logIndex, MAX_SEGMENT_FILE_SIZE, this.segmentsPath);
            LOG.info("Create a new segment file {} with firstLogIndex={}.", (Object)segmentFile.getPath(), (Object)logIndex);
            if (!segmentFile.init(new SegmentFile.SegmentFileOptions(false, true, 0))) {
                throw new IOException("Fail to create new segment file for logIndex: " + logIndex);
            }
            this.segments.add(segmentFile);
            SegmentFile segmentFile2 = segmentFile;
            return segmentFile2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void onSync() throws IOException {
        SegmentFile lastSegmentFile = this.getLastSegmentFileForRead();
        if (lastSegmentFile != null) {
            lastSegmentFile.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean onInitLoaded() {
        long startMs = Utils.monotonicMs();
        this.writeLock.lock();
        try {
            boolean normalExit;
            CheckpointFile.Checkpoint checkpoint;
            File segmentsDir = new File(this.segmentsPath);
            try {
                FileUtils.forceMkdir((File)segmentsDir);
            }
            catch (IOException e) {
                LOG.error("Fail to create segments directory: {}", (Object)this.segmentsPath, (Object)e);
                boolean bl = false;
                this.writeLock.unlock();
                LOG.info("{} init and load cost {} ms.", (Object)this.getServiceName(), (Object)(Utils.monotonicMs() - startMs));
                return bl;
            }
            try {
                checkpoint = this.checkpointFile.load();
                if (checkpoint != null) {
                    LOG.info("Loaded checkpoint: {} from {}.", (Object)checkpoint, (Object)this.checkpointFile.getPath());
                }
            }
            catch (IOException e) {
                LOG.error("Fail to load checkpoint file: {}", (Object)this.checkpointFile.getPath(), (Object)e);
                boolean bl = false;
                this.writeLock.unlock();
                LOG.info("{} init and load cost {} ms.", (Object)this.getServiceName(), (Object)(Utils.monotonicMs() - startMs));
                return bl;
            }
            File[] segmentFiles = segmentsDir.listFiles((dir, name) -> SEGMENT_FILE_NAME_PATTERN.matcher(name).matches());
            boolean bl = normalExit = !this.abortFile.exists();
            if (!normalExit) {
                LOG.info("{} {} did not exit normally, will try to recover last file.", (Object)this.getServiceName(), (Object)this.segmentsPath);
            }
            this.segments = new ArrayList<SegmentFile>(segmentFiles == null ? 10 : segmentFiles.length);
            if (segmentFiles != null && segmentFiles.length > 0) {
                Arrays.sort(segmentFiles, Comparator.comparing(a -> Long.valueOf(a.getName())));
                String checkpointFileName = this.getCheckpointFileName(checkpoint);
                boolean needRecover = false;
                SegmentFile prevFile = null;
                for (int i = 0; i < segmentFiles.length; ++i) {
                    File segFile = segmentFiles[i];
                    boolean isLastFile = i == segmentFiles.length - 1;
                    int pos = (int)segFile.length();
                    if (segFile.getName().equals(checkpointFileName)) {
                        needRecover = true;
                        pos = checkpoint.committedPos;
                    } else if (needRecover) {
                        pos = 0;
                    }
                    long firstLogIndex = Long.parseLong(segFile.getName());
                    SegmentFile segmentFile = new SegmentFile(firstLogIndex, MAX_SEGMENT_FILE_SIZE, this.segmentsPath);
                    if (!segmentFile.init(new SegmentFile.SegmentFileOptions(needRecover && !normalExit, isLastFile, pos))) {
                        LOG.error("Fail to load segment file {}.", (Object)segmentFile.getPath());
                        segmentFile.shutdown();
                        boolean bl2 = false;
                        return bl2;
                    }
                    this.segments.add(segmentFile);
                    if (prevFile != null) {
                        prevFile.setLastLogIndex(firstLogIndex - 1L);
                    }
                    prevFile = segmentFile;
                }
                if (this.getLastLogIndex() > 0L) {
                    prevFile.setLastLogIndex(this.getLastLogIndex());
                }
            } else if (checkpoint != null) {
                LOG.warn("Missing segment files, checkpoint is: {}", (Object)checkpoint);
                boolean bl3 = false;
                return bl3;
            }
            LOG.info("{} Loaded {} segment files from path {}.", new Object[]{this.getServiceName(), this.segments.size(), this.segmentsPath});
            LOG.info("{} segments: \n{}", (Object)this.getServiceName(), (Object)this.descSegments());
            this.startCheckpointTask();
            if (normalExit) {
                if (!this.abortFile.create()) {
                    LOG.error("Fail to create abort file {}.", (Object)this.abortFile.getPath());
                    boolean bl4 = false;
                    return bl4;
                }
            } else {
                this.abortFile.touch();
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (Exception e) {
            LOG.error("Fail to load segment files from directory {}.", (Object)this.segmentsPath, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            LOG.info("{} init and load cost {} ms.", (Object)this.getServiceName(), (Object)(Utils.monotonicMs() - startMs));
        }
    }

    private String getCheckpointFileName(CheckpointFile.Checkpoint checkpoint) {
        return checkpoint != null ? SegmentFile.getSegmentFileName(checkpoint.firstLogIndex) : null;
    }

    private void startCheckpointTask() {
        this.checkpointExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(this.getServiceName() + "-Checkpoint-Thread-", true));
        this.checkpointExecutor.scheduleAtFixedRate(this::doCheckpoint, DEFAULT_CHECKPOINT_INTERVAL_MS, DEFAULT_CHECKPOINT_INTERVAL_MS, TimeUnit.MILLISECONDS);
        LOG.info("{} started checkpoint task.", (Object)this.getServiceName());
    }

    private StringBuilder descSegments() {
        StringBuilder segmentsDesc = new StringBuilder("[\n");
        for (SegmentFile segFile : this.segments) {
            segmentsDesc.append("  ").append(segFile.toString()).append("\n");
        }
        segmentsDesc.append("]");
        return segmentsDesc;
    }

    private String getServiceName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onShutdown() {
        this.stopCheckpointTask();
        List<SegmentFile> shutdownFiles = Collections.emptyList();
        this.writeLock.lock();
        try {
            this.doCheckpoint();
            shutdownFiles = new ArrayList<SegmentFile>(shutdownFiles);
            this.segments.clear();
            if (!this.abortFile.destroy()) {
                LOG.error("Fail to delete abort file {}.", (Object)this.abortFile.getPath());
            }
        }
        finally {
            this.writeLock.unlock();
            for (SegmentFile segmentFile : shutdownFiles) {
                segmentFile.shutdown();
            }
        }
    }

    private void stopCheckpointTask() {
        if (this.checkpointExecutor != null) {
            this.checkpointExecutor.shutdownNow();
            try {
                this.checkpointExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOG.info("{} stopped checkpoint task.", (Object)this.getServiceName());
        }
    }

    private void doCheckpoint() {
        SegmentFile lastSegmentFile = null;
        try {
            lastSegmentFile = this.getLastSegmentFileForRead();
            if (lastSegmentFile != null) {
                this.checkpointFile.save(new CheckpointFile.Checkpoint(lastSegmentFile.getFirstLogIndex(), lastSegmentFile.getCommittedPos()));
            }
        }
        catch (IOException e) {
            LOG.error("Fatal error, fail to do checkpoint, last segment file is {}.", (Object)(lastSegmentFile != null ? lastSegmentFile.getPath() : "null"), (Object)e);
        }
    }

    private SegmentFile getLastSegmentFileForRead() throws IOException {
        return this.getLastSegmentFile(-1L, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReset(long nextLogIndex) {
        this.writeLock.lock();
        try {
            this.checkpointFile.destroy();
            for (SegmentFile segmentFile : this.segments) {
                segmentFile.destroy();
            }
            this.segments.clear();
            LOG.info("Destroyed segments and checkpoint in path {} by resetting.", (Object)this.segmentsPath);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTruncatePrefix(long startIndex, long firstIndexKept) throws RocksDBException, IOException {
        this.writeLock.lock();
        try {
            int fromIndex = this.binarySearchFileIndexByLogIndex(startIndex);
            int toIndex = this.binarySearchFileIndexByLogIndex(firstIndexKept);
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex < 0) {
                return;
            }
            List<SegmentFile> removedFiles = this.segments.subList(fromIndex, toIndex);
            for (SegmentFile segmentFile : removedFiles) {
                segmentFile.destroy();
            }
            removedFiles.clear();
            this.doCheckpoint();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean isMetadata(byte[] data) {
        for (int offset = 0; offset < SegmentFile.MAGIC_BYTES_SIZE; ++offset) {
            if (data[offset] == SegmentFile.MAGIC_BYTES[offset]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTruncateSuffix(long lastIndexKept) throws RocksDBException, IOException {
        this.writeLock.lock();
        try {
            byte[] keptData;
            byte[] data;
            int keptFileIndex = this.binarySearchFileIndexByLogIndex(lastIndexKept);
            int toIndex = this.binarySearchFileIndexByLogIndex(this.getLastLogIndex());
            if (keptFileIndex < 0) {
                LOG.warn("Segment file not found by logIndex={} to be truncate_suffix, current segments:\n{}.", (Object)lastIndexKept, (Object)this.descSegments());
                return;
            }
            if (toIndex < 0) {
                toIndex = this.segments.size() - 1;
            }
            List<SegmentFile> removedFiles = this.segments.subList(keptFileIndex + 1, toIndex + 1);
            for (SegmentFile segmentFile : removedFiles) {
                segmentFile.destroy();
            }
            removedFiles.clear();
            SegmentFile keptFile = this.segments.get(keptFileIndex);
            int logWrotePos = -1;
            long nextIndex = lastIndexKept + 1L;
            long endIndex = Math.min(this.getLastLogIndex(), keptFile.getLastLogIndex());
            while (nextIndex <= endIndex && (data = this.getValueFromRocksDB(this.getKeyBytes(nextIndex))) != null) {
                if (data.length == LOCATION_METADATA_SIZE) {
                    if (!this.isMetadata(data)) {
                        ++nextIndex;
                        continue;
                    }
                    logWrotePos = this.getWrotePosition(data);
                    break;
                }
                ++nextIndex;
            }
            if (logWrotePos < 0 && !this.isMetadata(keptData = this.getValueFromRocksDB(this.getKeyBytes(lastIndexKept)))) {
                long prevIndex = lastIndexKept - 1L;
                long startIndex = keptFile.getFirstLogIndex();
                while (prevIndex >= startIndex) {
                    byte[] data2 = this.getValueFromRocksDB(this.getKeyBytes(prevIndex));
                    if (data2 != null) {
                        if (data2.length == LOCATION_METADATA_SIZE) {
                            if (!this.isMetadata(data2)) {
                                --prevIndex;
                                continue;
                            }
                            logWrotePos = this.getWrotePosition(data2);
                            byte[] logData = this.onDataGet(prevIndex, data2);
                            logWrotePos += SegmentFile.getWriteBytes(logData);
                            break;
                        }
                        --prevIndex;
                        continue;
                    }
                    throw new LogEntryCorruptedException("Log entry data not found at index=" + prevIndex);
                }
            }
            if (logWrotePos >= 0 && logWrotePos < keptFile.getSize()) {
                keptFile.truncateSuffix(logWrotePos, lastIndexKept);
            }
            this.doCheckpoint();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int getWrotePosition(byte[] data) {
        return Bits.getInt(data, SegmentFile.MAGIC_BYTES_SIZE + 2 + 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] onDataAppend(long logIndex, byte[] value) throws IOException {
        this.writeLock.lock();
        try {
            SegmentFile lastSegmentFile = this.getLastSegmentFile(logIndex, SegmentFile.getWriteBytes(value), true);
            if (value.length < this.valueSizeThreshold) {
                lastSegmentFile.setLastLogIndex(logIndex);
                byte[] byArray = value;
                return byArray;
            }
            long firstLogIndex = lastSegmentFile.getFirstLogIndex();
            int pos = lastSegmentFile.write(logIndex, value);
            byte[] byArray = this.encodeLocationMetadata(firstLogIndex, pos);
            return byArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private byte[] encodeLocationMetadata(long firstLogIndex, int pos) {
        byte[] newData = new byte[LOCATION_METADATA_SIZE];
        System.arraycopy(SegmentFile.MAGIC_BYTES, 0, newData, 0, SegmentFile.MAGIC_BYTES_SIZE);
        Bits.putLong(newData, SegmentFile.MAGIC_BYTES_SIZE + 2, firstLogIndex);
        Bits.putInt(newData, SegmentFile.MAGIC_BYTES_SIZE + 2 + 8, pos);
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int binarySearchFileIndexByLogIndex(long logIndex) {
        this.readLock.lock();
        try {
            if (this.segments.isEmpty()) {
                int n = -1;
                return n;
            }
            if (this.segments.size() == 1) {
                SegmentFile firstFile = this.segments.get(0);
                if (firstFile.contains(logIndex)) {
                    int n = 0;
                    return n;
                }
                int n = -1;
                return n;
            }
            int low = 0;
            int high = this.segments.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                SegmentFile file = this.segments.get(mid);
                if (file.getLastLogIndex() < logIndex) {
                    low = mid + 1;
                    continue;
                }
                if (file.getFirstLogIndex() > logIndex) {
                    high = mid - 1;
                    continue;
                }
                int n = mid;
                return n;
            }
            int n = -(low + 1);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile binarySearchFileByFirstLogIndex(long logIndex) {
        this.readLock.lock();
        try {
            if (this.segments.isEmpty()) {
                SegmentFile segmentFile = null;
                return segmentFile;
            }
            if (this.segments.size() == 1) {
                SegmentFile firstFile = this.segments.get(0);
                if (firstFile.getFirstLogIndex() == logIndex) {
                    SegmentFile segmentFile = firstFile;
                    return segmentFile;
                }
                SegmentFile segmentFile = null;
                return segmentFile;
            }
            int low = 0;
            int high = this.segments.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                SegmentFile file = this.segments.get(mid);
                if (file.getFirstLogIndex() < logIndex) {
                    low = mid + 1;
                    continue;
                }
                if (file.getFirstLogIndex() > logIndex) {
                    high = mid - 1;
                    continue;
                }
                SegmentFile segmentFile = file;
                return segmentFile;
            }
            SegmentFile segmentFile = null;
            return segmentFile;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected byte[] onDataGet(long logIndex, byte[] value) throws IOException {
        int offset;
        if (value == null || value.length != LOCATION_METADATA_SIZE) {
            return value;
        }
        for (offset = 0; offset < SegmentFile.MAGIC_BYTES_SIZE; ++offset) {
            if (value[offset] == SegmentFile.MAGIC_BYTES[offset]) continue;
            return value;
        }
        long firstLogIndex = Bits.getLong(value, offset += 2);
        int pos = Bits.getInt(value, offset + 8);
        SegmentFile file = this.binarySearchFileByFirstLogIndex(firstLogIndex);
        if (file == null) {
            return null;
        }
        return file.read(logIndex, pos);
    }
}

