/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.alipay.sofa.jraft.util.Bits;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroByteStringHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CheckpointFile {
    private static final int CHECKPOINT_METADATA_SIZE = 12;
    private final String path;

    public void destroy() {
        FileUtils.deleteQuietly((File)new File(this.path));
    }

    public String getPath() {
        return this.path;
    }

    public CheckpointFile(String path) {
        this.path = path;
    }

    public synchronized boolean save(Checkpoint checkpoint) throws IOException {
        ProtoBufFile file = new ProtoBufFile(this.path);
        byte[] data = new byte[12];
        Bits.putLong(data, 0, checkpoint.firstLogIndex);
        Bits.putInt(data, 8, checkpoint.committedPos);
        LocalFileMetaOutter.LocalFileMeta meta = LocalFileMetaOutter.LocalFileMeta.newBuilder().setUserMeta(ZeroByteStringHelper.wrap(data)).build();
        return file.save((Message)meta, true);
    }

    public Checkpoint load() throws IOException {
        ProtoBufFile file = new ProtoBufFile(this.path);
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)file.load();
        if (meta != null) {
            byte[] data = meta.getUserMeta().toByteArray();
            assert (data.length == 12);
            return new Checkpoint(Bits.getLong(data, 0), Bits.getInt(data, 8));
        }
        return null;
    }

    public static final class Checkpoint {
        public final long firstLogIndex;
        public final int committedPos;

        public Checkpoint(long firstLogIndex, int committedPos) {
            this.firstLogIndex = firstLogIndex;
            this.committedPos = committedPos;
        }

        public String toString() {
            return "Checkpoint [firstLogIndex=" + this.firstLogIndex + ", committedPos=" + this.committedPos + "]";
        }
    }
}

