/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.google.protobuf.Message;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcRequestProcessor<T extends Message>
extends AsyncUserProcessor<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(RpcRequestProcessor.class);
    private final Executor executor;

    public abstract Message processRequest(T var1, RpcRequestClosure var2);

    public RpcRequestProcessor(Executor executor) {
        this.executor = executor;
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, T request) {
        try {
            Message msg = this.processRequest(request, new RpcRequestClosure(bizCtx, asyncCtx));
            if (msg != null) {
                asyncCtx.sendResponse((Object)msg);
            }
        }
        catch (Throwable t) {
            LOG.error("handleRequest {} failed", request, (Object)t);
            asyncCtx.sendResponse((Object)RpcResponseFactory.newResponse(-1, "handleRequest internal error", new Object[0]));
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

