/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.entity.Checksum;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Copiable;
import com.alipay.sofa.jraft.util.CrcUtil;
import com.alipay.sofa.jraft.util.Endpoint;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerId
implements Copiable<PeerId>,
Serializable,
Checksum {
    private static final long serialVersionUID = 8083529734784884641L;
    private static final Logger LOG = LoggerFactory.getLogger(PeerId.class);
    private Endpoint endpoint = new Endpoint("0.0.0.0", 0);
    private int idx;
    private String str;
    private int priority = -1;
    public static final PeerId ANY_PEER = new PeerId();
    private long checksum;

    public PeerId() {
    }

    @Override
    public long checksum() {
        if (this.checksum == 0L) {
            this.checksum = CrcUtil.crc64(AsciiStringUtil.unsafeEncode(this.toString()));
        }
        return this.checksum;
    }

    public static PeerId emptyPeer() {
        return new PeerId();
    }

    @Override
    public PeerId copy() {
        return new PeerId(this.endpoint.copy(), this.idx, this.priority);
    }

    public static PeerId parsePeer(String s) {
        PeerId peer = new PeerId();
        if (peer.parse(s)) {
            return peer;
        }
        return null;
    }

    public PeerId(Endpoint endpoint, int idx) {
        this.endpoint = endpoint;
        this.idx = idx;
    }

    public PeerId(String ip, int port) {
        this(ip, port, 0);
    }

    public PeerId(String ip, int port, int idx) {
        this.endpoint = new Endpoint(ip, port);
        this.idx = idx;
    }

    public PeerId(Endpoint endpoint, int idx, int priority) {
        this.endpoint = endpoint;
        this.idx = idx;
        this.priority = priority;
    }

    public PeerId(String ip, int port, int idx, int priority) {
        this.endpoint = new Endpoint(ip, port);
        this.idx = idx;
        this.priority = priority;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getIp() {
        return this.endpoint.getIp();
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public int getIdx() {
        return this.idx;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isEmpty() {
        return this.getIp().equals("0.0.0.0") && this.getPort() == 0 && this.idx == 0;
    }

    public String toString() {
        if (this.str == null) {
            StringBuilder buf = new StringBuilder(this.endpoint.toString());
            if (this.idx != 0) {
                buf.append(':').append(this.idx);
            }
            if (this.priority != -1) {
                if (this.idx == 0) {
                    buf.append(':');
                }
                buf.append(':').append(this.priority);
            }
            this.str = buf.toString();
        }
        return this.str;
    }

    public boolean parse(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return false;
        }
        String[] tmps = StringUtils.splitPreserveAllTokens((String)s, (char)':');
        if (tmps.length < 2 || tmps.length > 4) {
            return false;
        }
        try {
            int port = Integer.parseInt(tmps[1]);
            this.endpoint = new Endpoint(tmps[0], port);
            switch (tmps.length) {
                case 3: {
                    this.idx = Integer.parseInt(tmps[2]);
                    break;
                }
                case 4: {
                    this.idx = tmps[2].equals("") ? 0 : Integer.parseInt(tmps[2]);
                    this.priority = Integer.parseInt(tmps[3]);
                    break;
                }
            }
            this.str = null;
            return true;
        }
        catch (Exception e) {
            LOG.error("Parse peer from string failed: {}.", (Object)s, (Object)e);
            return false;
        }
    }

    public boolean isPriorityNotElected() {
        return this.priority == 0;
    }

    public boolean isPriorityDisabled() {
        return this.priority <= -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + this.idx;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerId other = (PeerId)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return this.idx == other.idx;
    }
}

