/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public final class JRaftServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public static <S> JRaftServiceLoader<S> load(Class<S> service) {
        return JRaftServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> JRaftServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new JRaftServiceLoader<S>(service, loader);
    }

    public List<S> sort() {
        Iterator<S> it = this.iterator();
        ArrayList<S> sortList = new ArrayList<S>();
        while (it.hasNext()) {
            sortList.add(it.next());
        }
        if (sortList.size() <= 1) {
            return sortList;
        }
        sortList.sort((o1, o2) -> {
            SPI o1_spi = o1.getClass().getAnnotation(SPI.class);
            SPI o2_spi = o2.getClass().getAnnotation(SPI.class);
            int o1_priority = o1_spi == null ? 0 : o1_spi.priority();
            int o2_priority = o2_spi == null ? 0 : o2_spi.priority();
            return -(o1_priority - o2_priority);
        });
        return sortList;
    }

    public S first() {
        List<S> sortList = this.sort();
        if (sortList.isEmpty()) {
            throw JRaftServiceLoader.fail(this.service, "could not find any implementation for class");
        }
        return sortList.get(0);
    }

    public S find(String implName) {
        for (S s : this.providers.values()) {
            SPI spi = s.getClass().getAnnotation(SPI.class);
            if (spi == null || !spi.name().equalsIgnoreCase(implName)) continue;
            return s;
        }
        while (this.lookupIterator.hasNext()) {
            Object cls = this.lookupIterator.next();
            SPI spi = ((Class)cls).getAnnotation(SPI.class);
            if (spi == null || !spi.name().equalsIgnoreCase(implName)) continue;
            try {
                S provider = this.service.cast(((Class)cls).newInstance());
                this.providers.put(((Class)cls).getName(), provider);
                return provider;
            }
            catch (Throwable x) {
                throw JRaftServiceLoader.fail(this.service, "provider " + ((Class)cls).getName() + " could not be instantiated", x);
            }
        }
        throw JRaftServiceLoader.fail(this.service, "provider " + implName + " not found");
    }

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private JRaftServiceLoader(Class<S> service, ClassLoader loader) {
        this.service = Requires.requireNonNull(service, "service interface cannot be null");
        this.loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        this.reload();
    }

    private static ServiceConfigurationError fail(Class<?> service, String msg, Throwable cause) {
        return new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static ServiceConfigurationError fail(Class<?> service, String msg) {
        return new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static ServiceConfigurationError fail(Class<?> service, URL url, int line, String msg) {
        return JRaftServiceLoader.fail(service, url + ":" + line + ": " + msg);
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                throw JRaftServiceLoader.fail(service, u, lc, "illegal configuration-file syntax");
            }
            int cp = ln.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                throw JRaftServiceLoader.fail(service, u, lc, "illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                throw JRaftServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private Iterator<String> parse(Class<?> service, URL url) {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStream in = url.openStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            int lc = 1;
            while ((lc = this.parseLine(service, url, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            throw JRaftServiceLoader.fail(service, "error reading configuration file", x);
        }
        return names.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            final Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = JRaftServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.knownProviders.hasNext() || JRaftServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                Object cls = JRaftServiceLoader.this.lookupIterator.next();
                try {
                    Object provider = JRaftServiceLoader.this.service.cast(((Class)cls).newInstance());
                    JRaftServiceLoader.this.providers.put(((Class)cls).getName(), provider);
                    return provider;
                }
                catch (Throwable x) {
                    throw JRaftServiceLoader.fail(JRaftServiceLoader.this.service, "provider " + ((Class)cls).getName() + " could not be instantiated", x);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "com.alipay.sofa.jraft.util.JRaftServiceLoader[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<Class<S>> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = JRaftServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    throw JRaftServiceLoader.fail(this.service, "error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = JRaftServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public Class<S> next() {
            Class<?> cls;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String name = this.nextName;
            this.nextName = null;
            try {
                cls = Class.forName(name, false, this.loader);
            }
            catch (ClassNotFoundException x) {
                throw JRaftServiceLoader.fail(this.service, "provider " + name + " not found");
            }
            if (!this.service.isAssignableFrom(cls)) {
                throw JRaftServiceLoader.fail(this.service, "provider " + name + " not a subtype");
            }
            return cls;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

