/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFile
implements Lifecycle<SegmentFileOptions> {
    private static final int BLANK_HOLE_SIZE = 64;
    private static final Logger LOG = LoggerFactory.getLogger(SegmentFile.class);
    private static final int DATA_LENGTH_SIZE = 4;
    public static final byte[] MAGIC_BYTES = new byte[]{87, -118};
    public static final int MAGIC_BYTES_SIZE = MAGIC_BYTES.length;
    private final long firstLogIndex;
    private volatile long lastLogIndex = Long.MAX_VALUE;
    private int size;
    private final String path;
    private MappedByteBuffer buffer;
    private volatile int wrotePos;
    private volatile int committedPos;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Lock readLock = this.readWriteLock.readLock();

    public SegmentFile(long firstLogIndex, int size, String parentDir) {
        this.firstLogIndex = firstLogIndex;
        this.size = size;
        this.path = parentDir + File.separator + SegmentFile.getSegmentFileName(this.firstLogIndex);
    }

    static String getSegmentFileName(long logIndex) {
        return String.format("%019d", logIndex);
    }

    long getLastLogIndex() {
        return this.lastLogIndex;
    }

    int getWrotePos() {
        return this.wrotePos;
    }

    int getCommittedPos() {
        return this.committedPos;
    }

    long getFirstLogIndex() {
        return this.firstLogIndex;
    }

    int getSize() {
        return this.size;
    }

    String getPath() {
        return this.path;
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.writeLock.lock();
        try {
            this.lastLogIndex = lastLogIndex;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateSuffix(int wrotePos, long logIndex) {
        this.writeLock.lock();
        try {
            int oldPos = this.wrotePos;
            this.clear(wrotePos);
            this.wrotePos = wrotePos;
            this.lastLogIndex = logIndex;
            this.buffer.position(wrotePos);
            LOG.info("Segment file {} truncate suffix from pos={}, then set lastLogIndex={}, oldWrotePos={}, newWrotePos={}", new Object[]{this.path, wrotePos, logIndex, oldPos, this.wrotePos});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long logIndex) {
        this.readLock.lock();
        try {
            boolean bl = logIndex >= this.firstLogIndex && logIndex <= this.lastLogIndex;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int startPos) {
        this.writeLock.lock();
        try {
            if (startPos < 0 || startPos > this.size) {
                return;
            }
            int endPos = Math.min(this.size, startPos + 64);
            for (int i = startPos; i < endPos; ++i) {
                this.buffer.put(i, (byte)0);
            }
            this.fsync();
            LOG.info("Segment file {} cleared data in [{}, {}).", new Object[]{this.path, startPos, endPos});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean init(SegmentFileOptions opts) {
        this.writeLock.lock();
        if (this.buffer != null) {
            this.writeLock.unlock();
            SegmentFile.LOG.warn("Segment file {} already initialized, the status: {}.", (Object)this.path, (Object)this.toString());
            return true;
        }
        file = new File(this.path);
        if (file.exists()) {
            this.size = (int)file.length();
        }
        try {
            block27: {
                block28: {
                    block24: {
                        block25: {
                            block26: {
                                fc = this.openFileChannel(opts);
                                var4_5 = null;
                                this.buffer = opts.isLastFile != false ? fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.size) : fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.size);
                                this.buffer.limit(this.size);
                                if (!opts.recover) break block24;
                                if (this.recover(opts)) ** GOTO lbl36
                                var5_7 = false;
                                if (fc == null) break block25;
                                if (var4_5 == null) break block26;
                                try {
                                    fc.close();
                                }
                                catch (Throwable var6_10) {
                                    var4_5.addSuppressed(var6_10);
                                }
                                break block25;
                            }
                            fc.close();
                        }
                        return var5_7;
                    }
                    this.wrotePos = opts.pos;
                    this.buffer.position(this.wrotePos);
lbl36:
                    // 2 sources

                    if (!SegmentFile.$assertionsDisabled && this.wrotePos != this.buffer.position()) {
                        throw new AssertionError();
                    }
                    this.committedPos = this.wrotePos;
                    SegmentFile.LOG.info("Loaded segment file {}, wrotePosition={}, bufferPosition={}, mappedSize={}.", new Object[]{this.path, this.wrotePos, this.buffer.position(), this.size});
                    var5_8 = true;
                    if (fc == null) break block27;
                    if (var4_5 == null) break block28;
                    try {
                        fc.close();
                    }
                    catch (Throwable var6_11) {
                        var4_5.addSuppressed(var6_11);
                    }
                    break block27;
                }
                fc.close();
            }
            return var5_8;
            catch (Throwable var5_9) {
                try {
                    try {
                        var4_5 = var5_9;
                        throw var5_9;
                    }
                    catch (Throwable var7_12) {
                        if (fc != null) {
                            if (var4_5 != null) {
                                try {
                                    fc.close();
                                }
                                catch (Throwable var8_13) {
                                    var4_5.addSuppressed(var8_13);
                                }
                            } else {
                                fc.close();
                            }
                        }
                        throw var7_12;
                    }
                }
                catch (IOException e) {
                    SegmentFile.LOG.error("Fail to init segment file {}.", (Object)this.path, (Object)e);
                    var4_6 = false;
                    return var4_6;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private FileChannel openFileChannel(SegmentFileOptions opts) throws IOException {
        if (opts.isLastFile) {
            return FileChannel.open(Paths.get(this.path, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        return FileChannel.open(Paths.get(this.path, new String[0]), StandardOpenOption.READ);
    }

    private boolean recover(SegmentFileOptions opts) throws IOException {
        LOG.info("Start to recover segment file {} from position {}.", (Object)this.path, (Object)opts.pos);
        this.wrotePos = opts.pos;
        this.buffer.position(this.wrotePos);
        long start = Utils.monotonicMs();
        while (this.wrotePos < this.size) {
            if (this.buffer.remaining() < MAGIC_BYTES_SIZE) {
                LOG.error("Fail to recover segment file {}, missing magic bytes.", (Object)this.path);
                return false;
            }
            byte[] magicBytes = new byte[MAGIC_BYTES_SIZE];
            this.buffer.get(magicBytes);
            if (!Arrays.equals(MAGIC_BYTES, magicBytes)) {
                boolean truncateDirty = false;
                int i = 0;
                for (byte b : magicBytes) {
                    ++i;
                    if (b == 0) continue;
                    if (opts.isLastFile) {
                        LOG.error("Corrupted magic bytes in segment file {} at pos={}, will truncate it.", (Object)this.path, (Object)(this.wrotePos + i));
                        truncateDirty = true;
                        break;
                    }
                    LOG.error("Fail to recover segment file {}, invalid magic bytes: {} at pos={}.", new Object[]{this.path, BytesUtil.toHex(magicBytes), this.wrotePos});
                    return false;
                }
                if (truncateDirty) {
                    this.truncateFile();
                    break;
                }
                this.buffer.position(this.buffer.position() - MAGIC_BYTES_SIZE);
                break;
            }
            if (this.buffer.remaining() < 4) {
                LOG.error("Corrupted data length in segment file {} at pos={}, will truncate it.", (Object)this.path, (Object)this.buffer.position());
                this.truncateFile();
                break;
            }
            int dataLen = this.buffer.getInt();
            if (this.buffer.remaining() < dataLen) {
                LOG.error("Corrupted data in segment file {} at pos={},  expectDataLength={}, but remaining is {}, will truncate it.", new Object[]{this.path, this.buffer.position(), dataLen, this.buffer.remaining()});
                this.truncateFile();
                break;
            }
            this.buffer.position(this.buffer.position() + dataLen);
            this.wrotePos += MAGIC_BYTES_SIZE + 4 + dataLen;
        }
        LOG.info("Recover segment file {} cost {} millis.", (Object)this.path, (Object)(Utils.monotonicMs() - start));
        return true;
    }

    private void truncateFile() throws IOException {
        this.clear(this.wrotePos);
        this.buffer.position(this.wrotePos);
        LOG.warn("Truncated segment file {} from pos={}.", (Object)this.path, (Object)this.wrotePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reachesFileEndBy(long waitToWroteBytes) {
        this.readLock.lock();
        try {
            boolean bl = (long)this.wrotePos + waitToWroteBytes > (long)this.size;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isFull() {
        return this.reachesFileEndBy(1L);
    }

    static int getWriteBytes(byte[] data) {
        return MAGIC_BYTES_SIZE + 4 + data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(long logIndex, byte[] data) {
        this.writeLock.lock();
        try {
            assert (this.wrotePos == this.buffer.position());
            int pos = this.wrotePos;
            this.buffer.put(MAGIC_BYTES);
            this.buffer.putInt(data.length);
            this.buffer.put(data);
            this.wrotePos += MAGIC_BYTES_SIZE + 4 + data.length;
            this.lastLogIndex = logIndex;
            int n = pos;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(long logIndex, int pos) throws IOException {
        this.readLock.lock();
        try {
            if (logIndex < this.firstLogIndex || logIndex > this.lastLogIndex) {
                LOG.warn("Try to read data from segment file {} out of range, logIndex={}, readPos={}, firstLogIndex={}, lastLogIndex={}.", new Object[]{this.path, logIndex, pos, this.firstLogIndex, this.lastLogIndex});
                byte[] byArray = null;
                return byArray;
            }
            if (pos >= this.committedPos) {
                LOG.warn("Try to read data from segment file {} out of comitted position, logIndex={}, readPos={}, wrotePos={}, this.committedPos={}.", new Object[]{this.path, logIndex, pos, this.wrotePos, this.committedPos});
                byte[] byArray = null;
                return byArray;
            }
            ByteBuffer readBuffer = this.buffer.asReadOnlyBuffer();
            readBuffer.position(pos);
            if (readBuffer.remaining() < MAGIC_BYTES_SIZE) {
                throw new IOException("Missing magic buffer.");
            }
            readBuffer.position(pos + MAGIC_BYTES_SIZE);
            int dataLen = readBuffer.getInt();
            byte[] data = new byte[dataLen];
            readBuffer.get(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void sync() throws IOException {
        if (this.committedPos >= this.wrotePos) {
            return;
        }
        this.writeLock.lock();
        try {
            if (this.committedPos >= this.wrotePos) {
                return;
            }
            this.fsync();
            this.committedPos = this.wrotePos;
            LOG.debug("Commit segment file {} at pos {}.", (Object)this.path, (Object)this.committedPos);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void fsync() {
        if (this.buffer != null) {
            this.buffer.force();
        }
    }

    public void destroy() {
        this.writeLock.lock();
        try {
            this.shutdown();
            FileUtils.deleteQuietly((File)new File(this.path));
            LOG.info("Deleted segment file {}.", (Object)this.path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static void closeDirectBuffer(MappedByteBuffer cb) {
        block5: {
            boolean isOldJDK = System.getProperty("java.specification.version", "99").startsWith("1.");
            try {
                Class<?> unsafeClass;
                if (isOldJDK) {
                    Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
                    cleaner.setAccessible(true);
                    Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                    clean.setAccessible(true);
                    clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
                    break block5;
                }
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Method clean = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                clean.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                clean.invoke(theUnsafe, cb);
            }
            catch (Exception ex) {
                LOG.error("Fail to un-mapped segment file.", (Throwable)ex);
            }
        }
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            if (this.buffer == null) {
                return;
            }
            SegmentFile.closeDirectBuffer(this.buffer);
            this.buffer = null;
            LOG.info("Unloaded segment file {}, current status: {}.", (Object)this.path, (Object)this.toString());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return "SegmentFile [firstLogIndex=" + this.firstLogIndex + ", lastLogIndex=" + this.lastLogIndex + ", size=" + this.size + ", path=" + this.path + ", wrotePos=" + this.wrotePos + ", committedPos=" + this.committedPos + "]";
    }

    public static class SegmentFileOptions {
        public final boolean recover;
        public final int pos;
        public final boolean isLastFile;

        public SegmentFileOptions(boolean recover, boolean isLastFile, int pos) {
            this.isLastFile = isLastFile;
            this.recover = recover;
            this.pos = pos;
        }

        public String toString() {
            return "SegmentFileOptions [recover=" + this.recover + ", pos=" + this.pos + ", isLastFile=" + this.isLastFile + "]";
        }
    }
}

