/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.concurrent.Executor;

public class ResetPeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ResetPeerRequest> {
    public ResetPeerRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.ResetPeerRequest request) {
        return request.getPeerId();
    }

    @Override
    protected String getGroupId(CliRequests.ResetPeerRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ResetPeerRequest request, RpcRequestClosure done) {
        Configuration newConf = new Configuration();
        Iterator iterator = request.getNewPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = (String)iterator.next();
            if (peer.parse(peerIdStr)) {
                newConf.addPeer(peer);
                continue;
            }
            return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        LOG.info("Receive ResetPeerRequest to {} from {}, new conf is {}", new Object[]{ctx.node.getNodeId(), done.getBizContext().getRemoteAddress(), newConf});
        Status st = ctx.node.resetPeers(newConf);
        return RpcResponseFactory.newResponse(st);
    }

    public String interest() {
        return CliRequests.ResetPeerRequest.class.getName();
    }
}

